/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.algorithms;

import java.util.HashSet;
import java.util.Iterator;
import org.kramerlab.bmad.algorithms.CandidateGenerator;
import org.kramerlab.bmad.matrix.BooleanMatrix;

public class RestrictedIntersectionGenerator
implements CandidateGenerator {
    public BooleanMatrix generateCandidates(BooleanMatrix a, int dimension) {
        HashSet<Integer> availableIndices = new HashSet<Integer>();
        for (int i = 0; i < a.getHeight(); ++i) {
            availableIndices.add(i);
        }
        int w = a.getWidth();
        int h = a.getHeight();
        BooleanMatrix result = new BooleanMatrix(h, w);
        for (int i = 0; i < h; ++i) {
            int maxImplications = 0;
            int bestIndex = i;
            Iterator i$ = availableIndices.iterator();
            while (i$.hasNext()) {
                int j = (Integer)i$.next();
                if (i == j) continue;
                int countImplications = 0;
                for (int c = 0; c < w; ++c) {
                    if (a.apply(i, c) != 2 || a.apply(j, c) != 2) continue;
                    ++countImplications;
                }
                if (countImplications < maxImplications) continue;
                maxImplications = countImplications;
                bestIndex = j;
            }
            for (int c = 0; c < w; ++c) {
                result.update(i, c, (a.apply(i, c) & a.apply(bestIndex, c)) == 3 ? (byte)3 : 0);
            }
            availableIndices.remove(i);
            availableIndices.remove(bestIndex);
        }
        return result;
    }

    public String toString() {
        return "RestrictedIntersect";
    }
}

