/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.demo;

import org.kramerlab.bmad.algorithms.AssociationGenerator;
import org.kramerlab.bmad.algorithms.BooleanMatrixDecomposition;
import org.kramerlab.bmad.algorithms.CombinatorPipeline;
import org.kramerlab.bmad.algorithms.DensityGreedyCombinator;
import org.kramerlab.bmad.algorithms.FastLoc;
import org.kramerlab.bmad.algorithms.Iter;
import org.kramerlab.bmad.general.Tuple;
import org.kramerlab.bmad.matrix.BooleanMatrix;
import org.kramerlab.bmad.visualization.DecompositionLayout;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class Demo {
    public static void main(String ... _) throws Throwable {
        for (String file : new String[]{"datasets/demo.arff"}) {
            try {
                Instances instances = new ConverterUtils.DataSource(file).getDataSet();
                for (double tau = 0.15; tau < 0.25; tau += 0.01) {
                    BooleanMatrixDecomposition algorithm = new BooleanMatrixDecomposition(new AssociationGenerator(tau), new FastLoc(), new CombinatorPipeline(new DensityGreedyCombinator(), new Iter()), 1.0);
                    Tuple<Instances, Instances> t = algorithm.decompose(instances, Math.max(instances.numAttributes() / 100, 8));
                    Instances basisRows = (Instances)t._2;
                    Instances learnableRepresentation = (Instances)t._1;
                    DecompositionLayout.showDecomposition(file + " tau = " + tau, instances, learnableRepresentation, basisRows);
                    BooleanMatrix a = new BooleanMatrix(instances);
                    BooleanMatrix b = new BooleanMatrix(basisRows);
                    BooleanMatrix c = new BooleanMatrix(learnableRepresentation);
                    System.out.println("Relative reconstruction error for tau = " + tau + " = " + a.relativeReconstructionError(c.booleanProduct(b), 1.0));
                }
            }
            catch (Exception e) {
                System.out.println("The file '" + file + "' is probably not in the current directory.");
                System.out.println("Full stack trace: ");
                e.printStackTrace();
            }
        }
    }
}

