/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.experiments;

import org.kramerlab.bmad.algorithms.BooleanMatrixDecomposition;
import org.kramerlab.bmad.general.Tuple;
import org.kramerlab.bmad.matrix.BooleanMatrix;
import weka.core.converters.ConverterUtils;

public class DimensionToError {
    private static BooleanMatrixDecomposition[] algorithms = new BooleanMatrixDecomposition[]{BooleanMatrixDecomposition.BEST_UNCONFIGURED, BooleanMatrixDecomposition.BEST_CONFIGURED(0.1), BooleanMatrixDecomposition.BEST_CONFIGURED(0.2), BooleanMatrixDecomposition.BEST_CONFIGURED(0.3), BooleanMatrixDecomposition.BEST_CONFIGURED(0.4), BooleanMatrixDecomposition.BEST_CONFIGURED(0.5), BooleanMatrixDecomposition.BEST_CONFIGURED(0.6), BooleanMatrixDecomposition.LOC_ITER, BooleanMatrixDecomposition.DBP};

    public static void main(String[] args) throws Exception {
        String pathToDataset = args[0];
        int startDim = Integer.parseInt(args[1]);
        int endDim = Integer.parseInt(args[2]);
        int dimStep = Integer.parseInt(args[3]);
        double c = 1.0;
        System.out.print("dim ");
        for (BooleanMatrixDecomposition o : algorithms) {
            System.out.print(o + " ");
        }
        System.out.println();
        for (int dim = startDim; dim <= endDim; dim += dimStep) {
            System.out.print(dim + " ");
            for (BooleanMatrixDecomposition a : algorithms) {
                BooleanMatrix matrix = new BooleanMatrix(new ConverterUtils.DataSource(pathToDataset).getDataSet());
                Tuple<BooleanMatrix, BooleanMatrix> result = a.decompose(matrix, Math.min(matrix.getWidth(), dim));
                double err = matrix.relativeReconstructionError(((BooleanMatrix)result._1).booleanProduct((BooleanMatrix)result._2), c);
                System.out.print(err + " ");
            }
            System.out.println();
        }
    }
}

