/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.matrix;

import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import org.kramerlab.bmad.general.Function;
import org.kramerlab.bmad.general.Package;
import org.kramerlab.bmad.general.Tuple;
import org.kramerlab.bmad.matrix.RowMajor;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanMatrix {
    public static final byte TRUE = 3;
    public static final byte UNKNOWN = 1;
    public static final byte FALSE = 0;
    private int width;
    private int height;
    private byte[][] rows;

    public static byte not(byte b) {
        switch (b) {
            case 3: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 3;
            }
        }
        throw new IllegalArgumentException("b = " + b + " is not in {TRUE, FALSE, UNKNOWN}");
    }

    public BooleanMatrix(int h, int w) {
        this.height = h;
        this.width = w;
        this.rows = new byte[h][w];
    }

    public BooleanMatrix(BooleanMatrix b) {
        this(b.getHeight(), b.getWidth());
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                this.rows[r][c] = b.apply(r, c);
            }
        }
    }

    public BooleanMatrix(byte[][] rowMajor) {
        this.width = rowMajor[0].length;
        this.height = rowMajor.length;
        this.rows = rowMajor;
    }

    public BooleanMatrix(Instances instances) {
        this(instances.numInstances(), instances.numAttributes());
        int row = 0;
        for (Instance instance : instances) {
            for (int i = 0; i < instance.numValues(); ++i) {
                int col = instance.index(i);
                double value = instance.valueSparse(i);
                byte b = Double.isNaN(value) ? (byte)1 : (value == 0.0 ? (byte)0 : 3);
                this.update(row, col, b);
            }
            ++row;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void update(int r, int c, byte b) {
        this.rows[r][c] = b;
    }

    public byte apply(int r, int c) {
        return this.rows[r][c];
    }

    public byte apply(int c) {
        return this.rows[0][c];
    }

    public void update(int c, byte b) {
        this.rows[0][c] = b;
    }

    public BooleanMatrix getRows(List<Integer> indices) {
        byte[][] entries = new byte[indices.size()][this.width];
        int r = 0;
        for (int i : indices) {
            entries[r] = this.rows[i];
            ++r;
        }
        return new BooleanMatrix(entries);
    }

    public void baxoy(byte alpha, BooleanMatrix x) {
        if (alpha == 0) {
            return;
        }
        byte[] thisRow = this.rows[0];
        byte[] otherRow = x.rows[0];
        for (int c = 0; c < this.width; ++c) {
            thisRow[c] = (byte)(thisRow[c] | otherRow[c] & alpha);
        }
    }

    public BooleanMatrix getRow(int r) {
        return new BooleanMatrix(new byte[][]{this.rows[r]});
    }

    public void setRow(int r, BooleanMatrix row) {
        this.rows[r] = row.rows[0];
    }

    public BooleanMatrix booleanProduct(BooleanMatrix other) {
        if (this.width != other.height) {
            throw new IllegalArgumentException("Incompatible matrix dimensions: cannot multiply " + this.height + " x " + this.width + " matrix with a " + other.height + " x " + other.width + " matrix.");
        }
        BooleanMatrix result = new BooleanMatrix(this.height, other.width);
        for (int r = 0; r < this.height; ++r) {
            BooleanMatrix row = result.getRow(r);
            for (int c = 0; c < this.width; ++c) {
                row.baxoy(this.apply(r, c), other.getRow(c));
            }
        }
        return result;
    }

    public RowMajor<Byte> toRowMajor() {
        RowMajor<Byte> m = new RowMajor<Byte>(this.height, this.width, (byte)0);
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                m.update(r, c, this.rows[r][c]);
            }
        }
        return m;
    }

    public double reconstructionError(BooleanMatrix reconstruction, double onesWeight) {
        double totalError = 0.0;
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                byte thisByte = this.apply(r, c);
                if (thisByte == 1) continue;
                byte otherByte = reconstruction.apply(r, c);
                if (thisByte == 0 && otherByte != 0) {
                    totalError += 1.0;
                    continue;
                }
                if (thisByte != 3 || otherByte == 3) continue;
                totalError += onesWeight;
            }
        }
        return totalError;
    }

    public Tuple<Double, Double> relativeOneZeroZeroOneReconstructionError(BooleanMatrix reconstruction, double onesWeight) {
        double oneZeroError = 0.0;
        double zeroOneError = 0.0;
        double totalWeight = 0.0;
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                byte thisByte = this.apply(r, c);
                if (thisByte == 1) continue;
                byte otherByte = reconstruction.apply(r, c);
                if (thisByte == 0) {
                    totalWeight += 1.0;
                    if (otherByte == 0) continue;
                    zeroOneError += 1.0;
                    continue;
                }
                if (thisByte != 3) continue;
                totalWeight += onesWeight;
                if (otherByte == 3) continue;
                oneZeroError += onesWeight;
            }
        }
        return Package.tuple(oneZeroError / totalWeight, zeroOneError / totalWeight);
    }

    public double relativeReconstructionError(BooleanMatrix reconstruction, double onesWeight) {
        Tuple<Double, Double> t = this.relativeOneZeroZeroOneReconstructionError(reconstruction, onesWeight);
        return (Double)t._1 + (Double)t._2;
    }

    public String toString() {
        return this.toRowMajor().map(new Function<Byte, Character>(){

            @Override
            public Character apply(Byte b) {
                return Character.valueOf((char)(b == 0 ? 46 : (b == 1 ? 63 : 49)));
            }
        }).toString();
    }

    public Image toImage() {
        return this.toRowMajor().toImage(new Function<Byte, Color>(){

            @Override
            public Color apply(Byte b) {
                switch (b) {
                    case 0: {
                        return Color.WHITE;
                    }
                    case 3: {
                        return Color.BLACK;
                    }
                    case 1: {
                        return Color.GRAY;
                    }
                }
                throw new IllegalArgumentException("b = " + b + " not ternary boolean.");
            }
        });
    }

    public Instances toInstances() {
        ArrayList<String> nominalValues = new ArrayList<String>();
        nominalValues.add("0");
        nominalValues.add("1");
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int c = 0; c < this.getWidth(); ++c) {
            attributes.add(new Attribute("col " + c, nominalValues));
        }
        Instances instances = new Instances("boolean matrix", attributes, this.getHeight());
        for (int r = 0; r < this.height; ++r) {
            double[] entries = new double[this.getWidth()];
            DenseInstance inst = new DenseInstance(1.0, entries);
            for (int c = 0; c < this.width; ++c) {
                byte b = this.apply(r, c);
                if (b == 1) {
                    inst.setMissing(c);
                    continue;
                }
                inst.setValue(c, b == 3 ? 1.0 : 0.0);
            }
            instances.add((Instance)inst);
        }
        return instances;
    }

    public BooleanMatrix mapBoolean(Function<Byte, Byte> function) {
        BooleanMatrix result = new BooleanMatrix(this.getHeight(), this.getWidth());
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                result.update(r, c, function.apply(this.apply(r, c)));
            }
        }
        return result;
    }

    public Tuple<Integer, Integer> size() {
        return Package.tuple(this.height, this.width);
    }

    public int[] elementCount() {
        int zeros = 0;
        int ones = 0;
        int unknowns = 0;
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                byte b = this.apply(r, c);
                if (b == 0) {
                    ++zeros;
                }
                if (b == 1) {
                    ++unknowns;
                }
                if (b != 3) continue;
                ++ones;
            }
        }
        return new int[]{zeros, unknowns, ones};
    }
}

