/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.matrix;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.kramerlab.bmad.general.Function;
import org.kramerlab.bmad.general.Package;
import org.kramerlab.bmad.general.Tuple;
import org.kramerlab.bmad.general.layout.Center;
import org.kramerlab.bmad.general.layout.Padding;
import org.kramerlab.bmad.general.layout.ZeroPadding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowMajor<X> {
    protected ArrayList<ArrayList<X>> entries;
    protected int width;
    protected int height;

    protected RowMajor(int h, int w, ArrayList<ArrayList<X>> entries) {
        this.entries = entries;
        this.width = w;
        this.height = h;
    }

    public RowMajor(int h, int w, Function<Tuple<Integer, Integer>, X> fill) {
        this.entries = new ArrayList();
        for (int r = 0; r < h; ++r) {
            ArrayList<X> row = new ArrayList<X>();
            for (int c = 0; c < w; ++c) {
                row.add(fill.apply(Package.tuple(r, c)));
            }
            this.entries.add(row);
        }
        this.height = h;
        this.width = w;
    }

    public RowMajor(int h, int w, X defaultValue) {
        this(h, w, (X)Package.constant(defaultValue));
    }

    public static <X> RowMajor<X> asRowVector(ArrayList<X> list) {
        ArrayList<ArrayList<X>> entries = new ArrayList<ArrayList<X>>(list.size());
        entries.add(list);
        return new RowMajor(1, list.size(), entries);
    }

    public static <X> RowMajor<X> asColumnVector(ArrayList<X> list) {
        ArrayList entries = new ArrayList(list.size());
        for (X x : list) {
            ArrayList<X> row = new ArrayList<X>();
            row.add(x);
            entries.add(row);
        }
        return new RowMajor(list.size(), 1, entries);
    }

    public X apply(int row, int column) {
        return this.entries.get(row).get(column);
    }

    public X apply(int column) {
        return this.entries.get(0).get(column);
    }

    public void update(int row, int column, X value) {
        this.entries.get(row).set(column, value);
    }

    public void update(int column, X value) {
        this.entries.get(0).set(column, value);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public <Y> RowMajor<Y> map(Function<X, Y> f) {
        ArrayList e = new ArrayList();
        for (ArrayList<X> row : this.entries) {
            ArrayList<Y> newRow = new ArrayList<Y>();
            for (X entry : row) {
                newRow.add(f.apply(entry));
            }
            e.add(newRow);
        }
        return new RowMajor(this.height, this.width, e);
    }

    public <Y> RowMajor<Y> mapWithIndices(Function<Tuple<X, Tuple<Integer, Integer>>, Y> f) {
        ArrayList e = new ArrayList();
        int r = 0;
        for (ArrayList<X> row : this.entries) {
            ArrayList<Y> newRow = new ArrayList<Y>();
            int c = 0;
            for (X entry : row) {
                newRow.add(f.apply(Package.tuple(entry, Package.tuple(r, c))));
                ++c;
            }
            e.add(newRow);
            ++r;
        }
        return new RowMajor(this.height, this.width, e);
    }

    public <Y> RowMajor<Y> flatMap(Function<X, RowMajor<Y>> f) {
        int cc;
        if (this.width == 0 || this.height == 0) {
            return new RowMajor(0, 0, new ArrayList());
        }
        ArrayList<RowMajor<Y>> firstRow = new ArrayList<RowMajor<Y>>();
        int totalWidth = 0;
        for (int metacolumn = 0; metacolumn < this.width; ++metacolumn) {
            RowMajor<Y> m = f.apply(this.apply(0, metacolumn));
            totalWidth += m.width;
            firstRow.add(m);
        }
        int totalHeight = ((RowMajor)firstRow.get((int)0)).height;
        int[] metarowHeights = new int[this.height];
        metarowHeights[0] = ((RowMajor)firstRow.get((int)0)).height;
        ArrayList firstColumn = new ArrayList();
        firstColumn.add(firstRow.get(0));
        for (int metarow = 1; metarow < this.height; ++metarow) {
            RowMajor<Y> m = f.apply(this.apply(metarow, 0));
            metarowHeights[metarow] = m.height;
            totalHeight += m.height;
            firstColumn.add(m);
        }
        ArrayList newEntries = new ArrayList();
        for (int h : metarowHeights) {
            for (int i = 0; i < h; ++i) {
                newEntries.add(new ArrayList(totalWidth));
            }
        }
        int totalRow = metarowHeights[0];
        for (int rr = 1; rr < this.height; ++rr) {
            for (ArrayList<X> row : ((RowMajor)firstColumn.get((int)rr)).entries) {
                ((ArrayList)newEntries.get(totalRow)).addAll(row);
                ++totalRow;
            }
        }
        for (cc = 0; cc < this.width; ++cc) {
            totalRow = 0;
            for (ArrayList<X> row : ((RowMajor)firstRow.get((int)cc)).entries) {
                ((ArrayList)newEntries.get(totalRow)).addAll(row);
                ++totalRow;
            }
        }
        for (cc = 1; cc < this.width; ++cc) {
            totalRow = ((RowMajor)firstRow.get((int)0)).height;
            for (int rr = 1; rr < this.height; ++rr) {
                for (ArrayList<X> row : f.apply(this.apply((int)rr, (int)cc)).entries) {
                    ((ArrayList)newEntries.get(totalRow)).addAll(row);
                    ++totalRow;
                }
            }
        }
        return new RowMajor(totalHeight, totalWidth, newEntries);
    }

    public String toString(Padding padding, String begin, String end, String columnSeparator, String rowSeparator) {
        RowMajor strings = this.map(new Function<X, String>(){

            @Override
            public String apply(X x) {
                return x.toString();
            }
        });
        int[] maxWidths = new int[this.width];
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                maxWidths[c] = Math.max(maxWidths[c], ((String)strings.apply(r, c)).length());
            }
        }
        StringBuilder b = new StringBuilder();
        b.append(begin);
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                b.append(padding.padLine(maxWidths[c], ' ', this.apply(r, c).toString()));
                if (c == this.width - 1) continue;
                b.append(columnSeparator);
            }
            if (r == this.height - 1) continue;
            b.append(rowSeparator);
        }
        b.append(end);
        return b.toString();
    }

    protected String toString(final Function<Integer, Padding> columnToHorizontalPadding, final Function<Integer, Padding> rowToVerticalPadding) {
        RowMajor<Object> blocks = this.map(new Function<X, String>(){

            @Override
            public String apply(X x) {
                return x.toString();
            }
        });
        RowMajor<Tuple<Integer, Integer>> blockDims = blocks.map(new Function<String, Tuple<Integer, Integer>>(){

            @Override
            public Tuple<Integer, Integer> apply(String s) {
                String[] lines = s.split("\n");
                int width = 0;
                for (String line : lines) {
                    width = Math.max(width, line.length());
                }
                return Package.tuple(lines.length, width);
            }
        });
        final int[] maxWidths = new int[this.width];
        final int[] maxHeights = new int[this.height];
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                Tuple<Integer, Integer> dim = blockDims.apply(r, c);
                maxWidths[c] = Math.max(maxWidths[c], (Integer)dim._2);
                maxHeights[r] = Math.max(maxHeights[r], (Integer)dim._1);
            }
        }
        RowMajor<String> paddedBlocks = blocks.mapWithIndices(new Function<Tuple<String, Tuple<Integer, Integer>>, String>(){

            @Override
            public String apply(Tuple<String, Tuple<Integer, Integer>> t) {
                String str = (String)t._1;
                int r = (Integer)((Tuple)t._2)._1;
                int c = (Integer)((Tuple)t._2)._2;
                return ((Padding)rowToVerticalPadding.apply(r)).padBlockVertically(maxHeights[r], ' ', ((Padding)columnToHorizontalPadding.apply(c)).padBlockHorizontally(maxWidths[c], ' ', str));
            }
        });
        return paddedBlocks.toString(new ZeroPadding(), "", "", " ", "\n");
    }

    public String toString() {
        return this.toString(Package.constant(new Center()), Package.constant(new Center()));
    }

    public Image toImage(Function<X, Color> toColor) {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics g = img.getGraphics();
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                g.setColor(toColor.apply(this.apply(r, c)));
                g.fillRect(c, r, 1, 1);
            }
        }
        return img;
    }

    public Tuple<Integer, Integer> size() {
        return Package.tuple(this.height, this.width);
    }
}

