/*
 * Decompiled with CFR 0.152.
 */
package org.ktorm.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ktorm.entity.Entity;
import org.ktorm.jackson.EntityDeserializers;
import org.ktorm.jackson.JacksonExtensionsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/ktorm/jackson/EntityDeserializers;", "Lcom/fasterxml/jackson/databind/module/SimpleDeserializers;", "()V", "findBeanDeserializer", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "config", "Lcom/fasterxml/jackson/databind/DeserializationConfig;", "beanDesc", "Lcom/fasterxml/jackson/databind/BeanDescription;", "Companion", "DeserializerImpl", "ktorm-jackson"})
public final class EntityDeserializers
extends SimpleDeserializers {
    private static final long serialVersionUID = 1L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public JsonDeserializer<?> findBeanDeserializer(@NotNull JavaType type, @NotNull DeserializationConfig config, @NotNull BeanDescription beanDesc) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)beanDesc, (String)"beanDesc");
        Class clazz = type.getRawClass();
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"type.rawClass");
        KClass ktClass = JvmClassMappingKt.getKotlinClass((Class)clazz);
        if (KClasses.isSubclassOf((KClass)ktClass, (KClass)Reflection.getOrCreateKotlinClass(Entity.class))) {
            return new DeserializerImpl(ktClass);
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J,\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00150\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\fH\u0002R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/ktorm/jackson/EntityDeserializers$DeserializerImpl;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/ktorm/entity/Entity;", "entityClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "getEntityClass", "()Lkotlin/reflect/KClass;", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intoValue", "deserializeWithType", "", "typeDeserializer", "Lcom/fasterxml/jackson/databind/jsontype/TypeDeserializer;", "findWritableProperties", "", "", "Lkotlin/reflect/KProperty1;", "ctx", "ktorm-jackson"})
    private static final class DeserializerImpl
    extends JsonDeserializer<Entity<?>> {
        @NotNull
        private final KClass<?> entityClass;

        @NotNull
        public Entity<?> deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            Entity entity = Entity.Companion.create(this.entityClass);
            this.deserialize(parser, ctxt, entity);
            return entity;
        }

        private final Map<String, KProperty1<?, ?>> findWritableProperties(JsonParser parser, DeserializationContext ctx) {
            return MapsKt.toMap((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)KClasses.getMemberProperties(this.entityClass)), (Function1)findWritableProperties.1.INSTANCE), (Function1)findWritableProperties.2.INSTANCE), (Function1)findWritableProperties.3.INSTANCE), (Function1)findWritableProperties.4.INSTANCE), (Function1)new Function1<KProperty1<? extends Object, ?>, Sequence<? extends Pair<? extends String, ? extends KProperty1<? extends Object, ?>>>>(parser, ctx){
                final /* synthetic */ JsonParser $parser;
                final /* synthetic */ DeserializationContext $ctx;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Sequence<Pair<String, KProperty1<? extends Object, ?>>> invoke(@NotNull KProperty1<? extends Object, ?> prop) {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter(prop, (String)"prop");
                    ObjectCodec objectCodec = this.$parser.getCodec();
                    Intrinsics.checkNotNullExpressionValue((Object)objectCodec, (String)"parser.codec");
                    DeserializationConfig deserializationConfig = this.$ctx.getConfig();
                    Intrinsics.checkNotNullExpressionValue((Object)deserializationConfig, (String)"ctx.config");
                    List<String> names = JacksonExtensionsKt.deserializeNamesForProperty(objectCodec, prop, (MapperConfig)deserializationConfig);
                    Iterable $this$map$iv = names;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Pair pair = TuplesKt.to((Object)it, prop);
                        collection.add(pair);
                    }
                    return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
                }
                {
                    this.$parser = jsonParser;
                    this.$ctx = deserializationContext;
                    super(1);
                }
            }));
        }

        @NotNull
        public Entity<?> deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext ctxt, @NotNull Entity<?> intoValue) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            Intrinsics.checkNotNullParameter(intoValue, (String)"intoValue");
            Map<String, KProperty1<?, ?>> properties = this.findWritableProperties(parser, ctxt);
            if (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                parser.nextToken();
            }
            while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
                if (parser.getCurrentToken() != JsonToken.FIELD_NAME) {
                    ctxt.reportWrongTokenException(JvmClassMappingKt.getJavaClass(this.entityClass), JsonToken.FIELD_NAME, null, new Object[0]);
                }
                KProperty1<?, ?> prop = properties.get(parser.getCurrentName());
                parser.nextToken();
                if (prop != null) {
                    JavaType propType = ctxt.constructType(JacksonExtensionsKt.getPropertyType(prop));
                    intoValue.set(prop.getName(), parser.getCodec().readValue(parser, (ResolvedType)propType));
                } else {
                    JsonToken jsonToken = parser.getCurrentToken();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonToken, (String)"parser.currentToken");
                    if (jsonToken.isStructStart()) {
                        parser.skipChildren();
                    }
                }
                parser.nextToken();
            }
            return intoValue;
        }

        @NotNull
        public Object deserializeWithType(@NotNull JsonParser parser, @NotNull DeserializationContext ctxt, @NotNull TypeDeserializer typeDeserializer) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            Intrinsics.checkNotNullParameter((Object)typeDeserializer, (String)"typeDeserializer");
            Object object = typeDeserializer.deserializeTypedFromObject(parser, ctxt);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeDeserializer.deseria\u2026dFromObject(parser, ctxt)");
            return object;
        }

        @NotNull
        public final KClass<?> getEntityClass() {
            return this.entityClass;
        }

        public DeserializerImpl(@NotNull KClass<?> entityClass) {
            Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
            this.entityClass = entityClass;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/ktorm/jackson/EntityDeserializers$Companion;", "", "()V", "serialVersionUID", "", "ktorm-jackson"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

