/*
 * Decompiled with CFR 0.152.
 */
package org.ktorm.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ktorm.entity.Entity;
import org.ktorm.jackson.EntitySerializers;
import org.ktorm.jackson.JacksonExtensionsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/ktorm/jackson/EntitySerializers;", "Lcom/fasterxml/jackson/databind/module/SimpleSerializers;", "()V", "findSerializer", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "config", "Lcom/fasterxml/jackson/databind/SerializationConfig;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "beanDesc", "Lcom/fasterxml/jackson/databind/BeanDescription;", "Companion", "SerializerImpl", "ktorm-jackson"})
public final class EntitySerializers
extends SimpleSerializers {
    private static final long serialVersionUID = 1L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public JsonSerializer<?> findSerializer(@NotNull SerializationConfig config, @NotNull JavaType type, @NotNull BeanDescription beanDesc) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)beanDesc, (String)"beanDesc");
        if (type.isTypeOrSubTypeOf(Entity.class)) {
            return SerializerImpl.INSTANCE;
        }
        return super.findSerializer(config, type, beanDesc);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00052\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J$\u0010\t\u001a\u00020\n2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u00020\n2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u0010\u001a\u00020\n2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/ktorm/jackson/EntitySerializers$SerializerImpl;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/ktorm/entity/Entity;", "()V", "findReadableProperties", "", "", "Lkotlin/reflect/KProperty1;", "entity", "serialize", "", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "serializeProperties", "serializeWithType", "typeSer", "Lcom/fasterxml/jackson/databind/jsontype/TypeSerializer;", "ktorm-jackson"})
    private static final class SerializerImpl
    extends JsonSerializer<Entity<?>> {
        @NotNull
        public static final SerializerImpl INSTANCE;

        public void serialize(@NotNull Entity<?> entity, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter(entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            JacksonExtensionsKt.configureIndentOutputIfEnabled(gen);
            gen.writeStartObject();
            this.serializeProperties(entity, gen, serializers);
            gen.writeEndObject();
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, KProperty1<?, ?>> findReadableProperties(Entity<?> entity) {
            void $this$associateByTo$iv$iv;
            Sequence $this$associateBy$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)KClasses.getMemberProperties((KClass)entity.getEntityClass())), (Function1)findReadableProperties.1.INSTANCE), (Function1)findReadableProperties.2.INSTANCE), (Function1)findReadableProperties.3.INSTANCE), (Function1)findReadableProperties.4.INSTANCE);
            boolean $i$f$associateBy = false;
            Sequence sequence = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                KProperty1 kProperty1 = (KProperty1)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                map.put(string, element$iv$iv);
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final void serializeProperties(Entity<?> entity, JsonGenerator gen, SerializerProvider serializers) {
            Map<String, KProperty1<?, ?>> properties = this.findReadableProperties(entity);
            Object object = entity.getProperties();
            boolean bl = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                KProperty1<?, ?> prop;
                void name;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = (String)entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Object value = entry2.getValue();
                if (properties.get(name) == null) {
                    continue;
                }
                ObjectCodec objectCodec = gen.getCodec();
                Intrinsics.checkNotNullExpressionValue((Object)objectCodec, (String)"gen.codec");
                SerializationConfig serializationConfig = serializers.getConfig();
                Intrinsics.checkNotNullExpressionValue((Object)serializationConfig, (String)"serializers.config");
                gen.writeFieldName(JacksonExtensionsKt.serializeNameForProperty(objectCodec, prop, (MapperConfig)serializationConfig));
                if (value == null) {
                    gen.writeNull();
                    continue;
                }
                JavaType propType = serializers.constructType(JacksonExtensionsKt.getPropertyType(prop));
                JsonSerializer ser = serializers.findTypedValueSerializer(propType, true, null);
                ser.serialize(value, gen, serializers);
            }
        }

        public void serializeWithType(@NotNull Entity<?> entity, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers, @NotNull TypeSerializer typeSer) {
            Intrinsics.checkNotNullParameter(entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            Intrinsics.checkNotNullParameter((Object)typeSer, (String)"typeSer");
            JacksonExtensionsKt.configureIndentOutputIfEnabled(gen);
            WritableTypeId typeId = typeSer.writeTypePrefix(gen, typeSer.typeId(entity, JvmClassMappingKt.getJavaClass((KClass)entity.getEntityClass()), JsonToken.START_OBJECT));
            this.serializeProperties(entity, gen, serializers);
            typeSer.writeTypeSuffix(gen, typeId);
        }

        private SerializerImpl() {
        }

        static {
            SerializerImpl serializerImpl;
            INSTANCE = serializerImpl = new SerializerImpl();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/ktorm/jackson/EntitySerializers$Companion;", "", "()V", "serialVersionUID", "", "ktorm-jackson"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

