/*
 * Decompiled with CFR 0.152.
 */
package org.ktorm.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ktorm.schema.SqlType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014\u00a2\u0006\u0002\u0010\u001bJ%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020$H\u0002J'\u0010%\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u000e\b\u0001\u0012\n \u0011*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/ktorm/jackson/JsonSqlType;", "T", "", "Lorg/ktorm/schema/SqlType;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "javaType", "Lcom/fasterxml/jackson/databind/JavaType;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/fasterxml/jackson/databind/JavaType;)V", "getJavaType", "()Lcom/fasterxml/jackson/databind/JavaType;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "pgObjectClass", "Ljava/lang/Class;", "pgObjectConstructor", "Ljava/lang/reflect/Constructor;", "kotlin.jvm.PlatformType", "pgStatementClass", "setTypeMethod", "Ljava/lang/reflect/Method;", "setValueMethod", "doGetResult", "rs", "Ljava/sql/ResultSet;", "index", "", "(Ljava/sql/ResultSet;I)Ljava/lang/Object;", "doSetParameter", "", "ps", "Ljava/sql/PreparedStatement;", "parameter", "(Ljava/sql/PreparedStatement;ILjava/lang/Object;)V", "loadClass", "name", "", "setParameter", "ktorm-jackson"})
public final class JsonSqlType<T>
extends SqlType<T> {
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final JavaType javaType;
    @Nullable
    private final Class<?> pgStatementClass;
    @Nullable
    private final Class<?> pgObjectClass;
    @Nullable
    private final Constructor<? extends Object> pgObjectConstructor;
    @Nullable
    private final Method setTypeMethod;
    @Nullable
    private final Method setValueMethod;

    public JsonSqlType(@NotNull ObjectMapper objectMapper, @NotNull JavaType javaType) {
        Method method;
        Method method2;
        Class[] classArray;
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)javaType, (String)"javaType");
        super(1111, "json");
        this.objectMapper = objectMapper;
        this.javaType = javaType;
        this.pgStatementClass = this.loadClass("org.postgresql.PGStatement");
        this.pgObjectClass = this.loadClass("org.postgresql.util.PGobject");
        Class<?> clazz = this.pgObjectClass;
        this.pgObjectConstructor = clazz != null ? clazz.getDeclaredConstructor(new Class[0]) : null;
        Class<?> clazz2 = this.pgObjectClass;
        if (clazz2 != null) {
            classArray = new Class[]{String.class};
            method2 = clazz2.getMethod("setType", classArray);
        } else {
            method2 = null;
        }
        this.setTypeMethod = method2;
        Class<?> clazz3 = this.pgObjectClass;
        if (clazz3 != null) {
            classArray = new Class[]{String.class};
            method = clazz3.getMethod("setValue", classArray);
        } else {
            method = null;
        }
        this.setValueMethod = method;
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    public final JavaType getJavaType() {
        return this.javaType;
    }

    private final Class<?> loadClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException _) {
            return null;
        }
    }

    public void setParameter(@NotNull PreparedStatement ps, int index, @Nullable T parameter) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        if (parameter != null) {
            this.doSetParameter(ps, index, parameter);
        } else if (this.pgStatementClass != null && ps.isWrapperFor(this.pgStatementClass)) {
            ps.setNull(index, 1111);
        } else {
            ps.setNull(index, 12);
        }
    }

    protected void doSetParameter(@NotNull PreparedStatement ps, int index, @NotNull T parameter) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
        if (this.pgStatementClass == null || !ps.isWrapperFor(this.pgStatementClass)) {
            ps.setString(index, this.objectMapper.writeValueAsString(parameter));
        } else {
            try {
                Constructor<? extends Object> constructor = this.pgObjectConstructor;
                Intrinsics.checkNotNull(constructor);
                Object obj = constructor.newInstance(new Object[0]);
                Method method = this.setTypeMethod;
                Intrinsics.checkNotNull((Object)method);
                Object[] objectArray = new Object[]{"json"};
                method.invoke(obj, objectArray);
                Method method2 = this.setValueMethod;
                Intrinsics.checkNotNull((Object)method2);
                objectArray = new Object[]{this.objectMapper.writeValueAsString(parameter)};
                method2.invoke(obj, objectArray);
                ps.setObject(index, obj);
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getTargetException();
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"e.targetException");
                throw throwable;
            }
        }
    }

    @Nullable
    protected T doGetResult(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        String json = rs.getString(index);
        CharSequence charSequence = json;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        return (T)this.objectMapper.readValue(json, this.javaType);
    }
}

