/*
 * Decompiled with CFR 0.152.
 */
package org.ktorm.jackson;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.Serializers;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.ktorm.jackson.EntityDeserializers;
import org.ktorm.jackson.EntitySerializers;
import org.ktorm.jackson.EntityTypeResolverBuilder;
import org.ktorm.jackson.PackageVersion;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/ktorm/jackson/KtormModule;", "Lcom/fasterxml/jackson/databind/Module;", "()V", "getModuleName", "", "setupModule", "", "context", "Lcom/fasterxml/jackson/databind/Module$SetupContext;", "version", "Lcom/fasterxml/jackson/core/Version;", "Companion", "ktorm-jackson"})
public final class KtormModule
extends Module {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    private static final long serialVersionUID = 1L;

    @NotNull
    public String getModuleName() {
        String string = PackageVersion.INSTANCE.getVERSION().getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PackageVersion.VERSION.artifactId");
        return string;
    }

    @NotNull
    public Version version() {
        return PackageVersion.INSTANCE.getVERSION();
    }

    public void setupModule(@NotNull Module.SetupContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.addSerializers((Serializers)new EntitySerializers());
        context.addDeserializers((Deserializers)new EntityDeserializers());
        try {
            ObjectCodec codec = context.getOwner();
            if (codec instanceof ObjectMapper) {
                TypeResolverBuilder deserializerTyper;
                JavaType objectType = ((ObjectMapper)codec).constructType((Type)((Object)Object.class));
                TypeResolverBuilder serializerTyper = ((ObjectMapper)codec).getSerializationConfig().getDefaultTyper(objectType);
                if (serializerTyper != null && serializerTyper instanceof ObjectMapper.DefaultTypeResolverBuilder) {
                    ((ObjectMapper)codec).setConfig((SerializationConfig)((ObjectMapper)codec).getSerializationConfig().with((TypeResolverBuilder)new EntityTypeResolverBuilder((ObjectMapper.DefaultTypeResolverBuilder)serializerTyper)));
                }
                if ((deserializerTyper = ((ObjectMapper)codec).getDeserializationConfig().getDefaultTyper(objectType)) != null && deserializerTyper instanceof ObjectMapper.DefaultTypeResolverBuilder) {
                    ((ObjectMapper)codec).setConfig((DeserializationConfig)((ObjectMapper)codec).getDeserializationConfig().with((TypeResolverBuilder)new EntityTypeResolverBuilder((ObjectMapper.DefaultTypeResolverBuilder)deserializerTyper)));
                }
            }
        }
        catch (Throwable e) {
            if (Intrinsics.areEqual((Object)e.getClass().getName(), (Object)"java.lang.reflect.InaccessibleObjectException")) {
                String msg = "Default typing is not supported because some hacking magic based on reflection failed. Please disable the default typing functionality by ObjectMapper.disableDefaultTyping(), or add the following VM arguments: --add-opens com.fasterxml.jackson.databind/com.fasterxml.jackson.databind=ktorm.jackson --add-opens com.fasterxml.jackson.databind/com.fasterxml.jackson.databind.jsontype.impl=ktorm.jackson ";
                throw new UnsupportedOperationException(msg, e);
            }
            throw e;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/ktorm/jackson/KtormModule$Companion;", "", "()V", "serialVersionUID", "", "ktorm-jackson"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

