/**
 * Copyright 2010-2012 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.property.processor;

import java.util.Properties;

import org.kuali.common.util.PropertyUtils;

public class AddPrefixProcessor implements PropertyProcessor {

	String prefix;

	public AddPrefixProcessor() {
		this(null);
	}

	public AddPrefixProcessor(String prefix) {
		super();
		this.prefix = prefix;
	}

	@Override
	public void process(Properties properties) {
		Properties duplicate = PropertyUtils.getPrefixedProperties(properties, prefix);
		properties.clear();
		properties.putAll(duplicate);
	}

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

}
