/**
 * Copyright 2010-2012 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.spring;

import java.util.List;

import org.kuali.common.util.CollectionUtils;
import org.springframework.beans.factory.FactoryBean;

public class GetListFromCSVFactoryBean implements FactoryBean<List<String>> {

	String csv;

	@Override
	public List<String> getObject() throws Exception {
		return CollectionUtils.getTrimmedListFromCSV(csv);
	}

	@Override
	public Class<?> getObjectType() {
		return null;
	}

	// TODO Fix getObjectType() with something along these lines, but without introducing compiler warnings
	// @Override
	// public Class<List> getObjectType() {
	// return List.class;
	// }

	@Override
	public boolean isSingleton() {
		return false;
	}

	public String getCsv() {
		return csv;
	}

	public void setCsv(String csv) {
		this.csv = csv;
	}
}
