/**
 * Copyright 2010-2012 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.spring;

import org.kuali.common.util.service.LocationService;
import org.springframework.beans.factory.FactoryBean;

public class ToStringFactoryBean extends ToStringContext implements FactoryBean<String> {

	LocationService service = new LocationService();

	@Override
	public String getObject() throws Exception {
		return service.toString(this);
	}

	@Override
	public Class<String> getObjectType() {
		return String.class;
	}

	@Override
	public boolean isSingleton() {
		return false;
	}

	public LocationService getService() {
		return service;
	}

	public void setService(LocationService service) {
		this.service = service;
	}

}
