/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import org.jasypt.util.text.BasicTextEncryptor;
import org.jasypt.util.text.StrongTextEncryptor;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.EncryptionStrength;

public class EncUtils {
    public static final TextEncryptor getTextEncryptor(String password) {
        return EncUtils.getTextEncryptor(EncryptionStrength.BASIC, password);
    }

    public static final TextEncryptor getTextEncryptor(EncryptionStrength strength, String password) {
        switch (strength) {
            case BASIC: {
                BasicTextEncryptor basic = new BasicTextEncryptor();
                basic.setPassword(password);
                return basic;
            }
            case STRONG: {
                StrongTextEncryptor strong = new StrongTextEncryptor();
                strong.setPassword(password);
                return strong;
            }
        }
        throw new IllegalArgumentException("Encryption strength '" + (Object)((Object)strength) + "' is unknown");
    }
}

