/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.Size;

public class FormatUtils {
    private static final double SECOND = 1000.0;
    private static final double MINUTE = 60000.0;
    private static final double HOUR = 3600000.0;
    private static final double DAY = 8.64E7;
    private static final double YEAR = 3.1536E10;
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ";
    private static final List<String> TIME_TOKENS = Arrays.asList("ms", "s", "m", "h", "d", "y");
    private static final List<Long> TIME_MULTIPLIERS = FormatUtils.getTimeMultipliers();
    private static final List<String> SIZE_TOKENS = Arrays.asList("b", "k", "m", "g", "t", "p", "e");
    private static final int BASE = 1024;
    private static NumberFormat largeSizeFormatter = NumberFormat.getInstance();
    private static NumberFormat sizeFormatter = NumberFormat.getInstance();
    private static NumberFormat timeFormatter = NumberFormat.getInstance();
    private static NumberFormat rateFormatter = NumberFormat.getInstance();
    private static NumberFormat countFormatter = NumberFormat.getInstance();

    public static long getBytes(String size) {
        return FormatUtils.getBytes(size, SIZE_TOKENS, 1024);
    }

    public static long getBytes(String size, List<String> tokens, int base) {
        Assert.notBlank(size);
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            long multiplier = (long)Math.pow(base, i);
            if (!StringUtils.endsWithIgnoreCase((CharSequence)size, (CharSequence)token)) continue;
            return FormatUtils.getByteValue(size, token, multiplier);
        }
        return FormatUtils.getByteValue(size, "", 1L);
    }

    protected static long getByteValue(String time, String suffix, long multiplier) {
        int len = StringUtils.length((CharSequence)time);
        String substring = StringUtils.substring((String)time, (int)0, (int)(len - suffix.length()));
        Double value = new Double(substring);
        value = value * (double)multiplier;
        return value.longValue();
    }

    public static long getMillis(String time) {
        return FormatUtils.getMillis(time, TIME_TOKENS, TIME_MULTIPLIERS);
    }

    public static long getMillis(String time, List<String> tokens, List<Long> multipliers) {
        Assert.notBlank(time);
        Assert.isTrue((tokens.size() == multipliers.size() ? 1 : 0) != 0);
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            long multiplier = multipliers.get(i);
            if (!StringUtils.endsWithIgnoreCase((CharSequence)time, (CharSequence)token)) continue;
            return FormatUtils.getTimeValue(time, token, multiplier);
        }
        return FormatUtils.getTimeValue(time, "", 1L);
    }

    protected static long getTimeValue(String time, String suffix, long multiplier) {
        int len = StringUtils.length((CharSequence)time);
        String substring = StringUtils.substring((String)time, (int)0, (int)(len - suffix.length()));
        Double value = new Double(substring);
        value = value * (double)multiplier;
        return value.longValue();
    }

    public static Date parseDate(String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            return sdf.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't parse [" + date + "]", e);
        }
    }

    public static String getDate(long millis) {
        return FormatUtils.getDate(new Date(millis));
    }

    public static String getDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(date);
    }

    public static String getThroughputInSeconds(long millis, long count, String label) {
        double seconds = (double)millis / 1000.0;
        double countPerSecond = (double)count / seconds;
        return countFormatter.format(countPerSecond) + " " + label;
    }

    public static String getRate(long millis, long bytes) {
        double seconds = (double)millis / 1000.0;
        double bytesPerSecond = (double)bytes / seconds;
        Size bandwidthLevel = FormatUtils.getSizeEnum(bytesPerSecond);
        double transferRate = bytesPerSecond / (double)bandwidthLevel.getValue();
        return rateFormatter.format(transferRate) + " " + bandwidthLevel.getRateLabel();
    }

    public static String getCount(long count) {
        return countFormatter.format(count);
    }

    public static String getTime(long millis) {
        long abs = Math.abs(millis);
        if ((double)abs < 1000.0) {
            return millis + "ms";
        }
        if ((double)abs < 60000.0) {
            return timeFormatter.format((double)millis / 1000.0) + "s";
        }
        if ((double)abs < 3600000.0) {
            return timeFormatter.format((double)millis / 60000.0) + "m";
        }
        if ((double)abs < 8.64E7) {
            return timeFormatter.format((double)millis / 3600000.0) + "h";
        }
        if ((double)abs < 3.1536E10) {
            return timeFormatter.format((double)millis / 8.64E7) + "d";
        }
        return timeFormatter.format((double)millis / 3.1536E10) + "y";
    }

    public static String getSize(long bytes) {
        return FormatUtils.getSize(bytes, null);
    }

    public static String getSize(long bytes, Size unitOfMeasure) {
        unitOfMeasure = unitOfMeasure == null ? FormatUtils.getSizeEnum(bytes) : unitOfMeasure;
        StringBuilder sb = new StringBuilder();
        sb.append(FormatUtils.getFormattedSize(bytes, unitOfMeasure));
        sb.append(unitOfMeasure.getSizeLabel());
        return sb.toString();
    }

    public static String getFormattedSize(long bytes, Size size) {
        switch (size) {
            case BYTE: {
                return bytes + "";
            }
            case KB: 
            case MB: 
            case GB: {
                return sizeFormatter.format((double)bytes / (double)size.getValue());
            }
        }
        return largeSizeFormatter.format((double)bytes / (double)size.getValue());
    }

    public static Size getSizeEnum(double bytes) {
        if ((bytes = Math.abs(bytes)) < (double)Size.KB.getValue()) {
            return Size.BYTE;
        }
        if (bytes < (double)Size.MB.getValue()) {
            return Size.KB;
        }
        if (bytes < (double)Size.GB.getValue()) {
            return Size.MB;
        }
        if (bytes < (double)Size.TB.getValue()) {
            return Size.GB;
        }
        if (bytes < (double)Size.PB.getValue()) {
            return Size.TB;
        }
        if (bytes < (double)Size.EB.getValue()) {
            return Size.PB;
        }
        return Size.EB;
    }

    protected static final List<Long> getTimeMultipliers() {
        ArrayList<Long> m = new ArrayList<Long>();
        m.add(1L);
        m.add(new Double(1000.0).longValue());
        m.add(new Double(60000.0).longValue());
        m.add(new Double(3600000.0).longValue());
        m.add(new Double(8.64E7).longValue());
        m.add(new Double(3.1536E10).longValue());
        return m;
    }

    static {
        sizeFormatter.setGroupingUsed(false);
        sizeFormatter.setMaximumFractionDigits(1);
        sizeFormatter.setMinimumFractionDigits(1);
        largeSizeFormatter.setGroupingUsed(false);
        largeSizeFormatter.setMaximumFractionDigits(3);
        largeSizeFormatter.setMinimumFractionDigits(3);
        timeFormatter.setGroupingUsed(false);
        timeFormatter.setMaximumFractionDigits(3);
        timeFormatter.setMinimumFractionDigits(3);
        rateFormatter.setGroupingUsed(false);
        rateFormatter.setMaximumFractionDigits(3);
        rateFormatter.setMinimumFractionDigits(3);
        countFormatter.setGroupingUsed(true);
        countFormatter.setMaximumFractionDigits(0);
        countFormatter.setMinimumFractionDigits(0);
    }
}

