/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.PrintStream;
import java.util.List;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.kuali.common.util.ignore.Ignore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintlnStreamConsumer
implements StreamConsumer {
    private static final Logger logger = LoggerFactory.getLogger(PrintlnStreamConsumer.class);
    PrintStream printStream;
    long lineCount = 0L;
    long skipCount = 0L;
    List<Ignore> ignorers;
    boolean enableIgnorers = true;

    public PrintlnStreamConsumer() {
        this(null);
    }

    public PrintlnStreamConsumer(PrintStream printStream) {
        this(printStream, null);
    }

    public PrintlnStreamConsumer(PrintStream printStream, List<Ignore> ignorers) {
        this.printStream = printStream;
        this.ignorers = ignorers;
    }

    public void consumeLine(String line) {
        ++this.lineCount;
        if (this.enableIgnorers && this.ignore(line, this.ignorers)) {
            ++this.skipCount;
            Object[] args = new Object[]{this.skipCount, this.lineCount, line};
            logger.debug("{} Skipping line {} [{}]", args);
        } else {
            this.printStream.println(line);
        }
    }

    protected boolean ignore(String line, List<Ignore> ignorers) {
        if (ignorers == null) {
            return false;
        }
        for (Ignore ignorer : ignorers) {
            if (!ignorer.ignore(line)) continue;
            return true;
        }
        return false;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    public long getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(long lineCount) {
        this.lineCount = lineCount;
    }

    public long getSkipCount() {
        return this.skipCount;
    }

    public void setSkipCount(long skipCount) {
        this.skipCount = skipCount;
    }

    public List<Ignore> getIgnorers() {
        return this.ignorers;
    }

    public void setIgnorers(List<Ignore> ignorers) {
        this.ignorers = ignorers;
    }
}

