/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Str {
    public static final String EMPTY_STRING = "";
    public static final String UTF8 = "UTF-8";
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String DOT = ".";
    public static final String FORWARD_SLASH = "/";
    public static final char DOUBLE_QUOTE = '\"';

    public static final String getString(byte[] bytes, String encoding) {
        if (bytes == null) {
            return null;
        }
        if (encoding == null) {
            return new String(bytes);
        }
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final byte[] getUTF8Bytes(String s) {
        if (s == null) {
            return null;
        }
        return Str.getBytes(s, UTF8);
    }

    public static final byte[] getBytes(String s, String encoding) {
        if (s == null) {
            return null;
        }
        if (encoding == null) {
            return s.getBytes();
        }
        try {
            return s.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final boolean contains(List<String> tokens, String value, boolean caseSensitive) {
        for (String token : tokens) {
            if (!Str.equals(token, value, caseSensitive)) continue;
            return true;
        }
        return false;
    }

    public static final boolean equals(String s1, String s2, boolean caseSensitive) {
        if (caseSensitive) {
            return StringUtils.equals((CharSequence)s1, (CharSequence)s2);
        }
        return StringUtils.equalsIgnoreCase((CharSequence)s1, (CharSequence)s2);
    }

    public static final String toString(String[] tokens) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            sb.append(token);
        }
        return sb.toString();
    }

    public static final String getPath(String s) {
        return StringUtils.trim((String)StringUtils.replace((String)s, (String)DOT, (String)FORWARD_SLASH));
    }

    public static final String quote(String s) {
        return s == null ? null : '\"' + s + '\"';
    }

    public static final String[] splitCSV(String csv, boolean trim) {
        return Str.split(csv, COMMA, trim);
    }

    public static final String[] splitAndTrimCSV(String csv) {
        return Str.splitCSV(csv, true);
    }

    public static final String[] splitAndTrim(String s, String separatorChars) {
        return Str.split(s, separatorChars, true);
    }

    public static final String[] split(String s, String separatorChars, boolean trim) {
        String[] tokens = StringUtils.split((String)s, (String)separatorChars);
        if (tokens == null) {
            return null;
        }
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = trim ? StringUtils.trim((String)tokens[i]) : tokens[i];
        }
        return tokens;
    }

    public static final String flatten(String s) {
        return Str.flatten(s, SPACE, SPACE);
    }

    public static final String flatten(String s, String cr, String lf) {
        return StringUtils.replace((String)StringUtils.replace((String)s, (String)CR, (String)cr), (String)LF, (String)lf);
    }
}

