/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kuali.common.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringFilter {
    private static final Logger logger = LoggerFactory.getLogger(StringFilter.class);
    List<String> includes;
    List<String> excludes;
    protected List<Pattern> includePatterns;
    protected List<Pattern> excludePatterns;

    protected StringFilter(List<String> includes, List<String> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public static final StringFilter getInstance(List<String> includes, List<String> excludes) {
        StringFilter filter = new StringFilter(includes, excludes);
        filter.compilePatterns();
        return filter;
    }

    public boolean include(String s) {
        if (this.exclude(s)) {
            logger.debug("Excluding {}", (Object)s);
            return false;
        }
        return CollectionUtils.isEmpty(this.includePatterns) || this.isMatch(s, this.includePatterns);
    }

    public boolean exclude(String s) {
        return !CollectionUtils.isEmpty(this.excludePatterns) && this.isMatch(s, this.excludePatterns);
    }

    protected boolean isMatch(String s, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(s);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    protected void compilePatterns() {
        this.includePatterns = this.getPatterns(this.includes);
        this.excludePatterns = this.getPatterns(this.excludes);
    }

    protected List<Pattern> getPatterns(List<String> patterns) {
        if (CollectionUtils.isEmpty(patterns)) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> regexPatterns = new ArrayList<Pattern>();
        for (String pattern : patterns) {
            Pattern regexPattern = Pattern.compile(pattern);
            regexPatterns.add(regexPattern);
        }
        return regexPatterns;
    }
}

