/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.util.Date;
import java.util.List;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutablesExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(ExecutablesExecutable.class);
    List<Executable> executables;
    boolean skip;
    boolean timed;

    @Override
    public void execute() {
        if (this.skip) {
            logger.info("Skipping execution of {} executables", (Object)CollectionUtils.toEmptyList(this.executables).size());
            return;
        }
        long start = System.currentTimeMillis();
        for (Executable executable : this.executables) {
            executable.execute();
        }
        long stop = System.currentTimeMillis();
        if (this.timed) {
            String elapsed = FormatUtils.getTime(stop - start);
            logger.info("------------------------------------------------------------------------");
            logger.info("Total Time: {}", (Object)elapsed);
            logger.info("Finished at: {}", (Object)new Date(stop));
            logger.info("------------------------------------------------------------------------");
        }
    }

    public List<Executable> getExecutables() {
        return this.executables;
    }

    public void setExecutables(List<Executable> executables) {
        this.executables = executables;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isTimed() {
        return this.timed;
    }

    public void setTimed(boolean timed) {
        this.timed = timed;
    }
}

