/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.execute.Executable;
import org.springframework.util.Assert;

public class StorePropertiesExecutable
implements Executable {
    String encoding = "UTF-8";
    boolean skip;
    Properties properties;
    File outputFile;
    List<String> includes;
    List<String> excludes;

    @Override
    public void execute() {
        if (this.skip) {
            return;
        }
        Assert.notNull((Object)this.properties, (String)"properties is null");
        Assert.notNull((Object)this.outputFile, (String)"outputFile is null");
        List<String> keys = PropertyUtils.getSortedKeys(this.properties, this.includes, this.excludes);
        Properties outputProperties = new Properties();
        for (String key : keys) {
            String value = this.properties.getProperty(key);
            outputProperties.setProperty(key, value);
        }
        PropertyUtils.store(outputProperties, this.outputFile, this.encoding);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

