/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.kuali.common.util.property.processor.PropertyProcessor;

public class CopyStringProcessor
implements PropertyProcessor {
    Object bean;
    String beanProperty;
    String propertyKey;

    public CopyStringProcessor() {
        this(null, null, null);
    }

    public CopyStringProcessor(Object bean, String beanProperty, String propertyKey) {
        this.bean = bean;
        this.beanProperty = beanProperty;
        this.propertyKey = propertyKey;
    }

    @Override
    public void process(Properties properties) {
        this.copyProperty(this.bean, this.beanProperty, properties, this.propertyKey);
    }

    protected void copyProperty(Object bean, String beanProperty, Properties properties, String propertyKey) {
        try {
            String value = properties.getProperty(propertyKey);
            BeanUtils.copyProperty((Object)bean, (String)beanProperty, (Object)value);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public String getBeanProperty() {
        return this.beanProperty;
    }

    public void setBeanProperty(String beanProperty) {
        this.beanProperty = beanProperty;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }
}

