/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.util.List;
import java.util.Properties;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.Mode;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.processor.DecryptProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndsWithDecryptProcessor
extends DecryptProcessor {
    private static final Logger logger = LoggerFactory.getLogger(EndsWithDecryptProcessor.class);
    String suffix = ".encrypted";
    boolean removeEncryptedProperties = true;
    Mode propertyOverwriteMode = Constants.DEFAULT_PROPERTY_OVERWRITE_MODE;

    public EndsWithDecryptProcessor() {
        this(null);
    }

    public EndsWithDecryptProcessor(TextEncryptor encryptor) {
        super(encryptor);
    }

    @Override
    public void process(Properties properties) {
        List<String> keys = PropertyUtils.getEndsWithKeys(properties, this.suffix);
        logger.info("Decrypting {} property values", (Object)keys.size());
        for (String key : keys) {
            logger.debug("Decrypting [{}]", (Object)key);
            String encryptedValue = properties.getProperty(key);
            String decryptedValue = this.decrypt(key, encryptedValue, this.encryptor);
            int endIndex = key.length() - this.suffix.length();
            String newKey = key.substring(0, endIndex);
            PropertyUtils.addOrOverrideProperty(properties, newKey, decryptedValue, this.propertyOverwriteMode);
            if (!this.removeEncryptedProperties) continue;
            logger.debug("Removing {}", (Object)key);
            properties.remove(key);
        }
    }

    protected String decrypt(String key, String encryptedValue, TextEncryptor encryptor) {
        try {
            return encryptor.decrypt(encryptedValue);
        }
        catch (EncryptionOperationNotPossibleException e) {
            throw new IllegalStateException("Unexpected error decrypting [" + key + "]=[" + encryptedValue + "]");
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isRemoveEncryptedProperties() {
        return this.removeEncryptedProperties;
    }

    public void setRemoveEncryptedProperties(boolean removeEncryptedProperties) {
        this.removeEncryptedProperties = removeEncryptedProperties;
    }

    public Mode getPropertyOverwriteMode() {
        return this.propertyOverwriteMode;
    }

    public void setPropertyOverwriteMode(Mode propertyOverwriteMode) {
        this.propertyOverwriteMode = propertyOverwriteMode;
    }
}

