/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.kuali.common.util.Mode;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class JdbcUrlProcessor
implements PropertyProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUrlProcessor.class);
    String jdbcUrlProperty = "jdbc.url";
    String dbVendorProperty = "db.vendor";
    Map<String, String> jdbcUrlFragments = this.getJdbcUrlFragments();
    Mode propertyOverwriteMode = Constants.DEFAULT_PROPERTY_OVERWRITE_MODE;

    @Override
    public void process(Properties properties) {
        Assert.notNull((Object)this.jdbcUrlProperty);
        Assert.notNull((Object)this.dbVendorProperty);
        String jdbcUrl = properties.getProperty(this.jdbcUrlProperty);
        if (jdbcUrl == null) {
            logger.info(this.jdbcUrlProperty + " is not set");
            return;
        }
        String databaseVendor = this.getMatch(jdbcUrl, this.jdbcUrlFragments);
        if (databaseVendor != null) {
            PropertyUtils.addOrOverrideProperty(properties, this.dbVendorProperty, databaseVendor, this.propertyOverwriteMode);
        } else {
            logger.info("Could not identify a database vendor from url - [{}]", (Object)jdbcUrl);
        }
    }

    protected String getMatch(String string, Map<String, String> fragments) {
        for (String fragment : fragments.keySet()) {
            if (!string.contains(fragment)) continue;
            return fragments.get(fragment);
        }
        return null;
    }

    protected Map<String, String> getJdbcUrlFragments() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(":hsqldb:", "hsql");
        m.put(":derby:", "derby");
        m.put(":postgresql:", "postgresql");
        m.put(":db2:", "db2");
        m.put(":mysql:", "mysql");
        m.put(":oracle:", "oracle");
        m.put(":h2:", "h2");
        return m;
    }
}

