/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.service.SpringContext;
import org.kuali.common.util.service.SpringService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class DefaultSpringService
implements SpringService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpringService.class);

    @Override
    public List<PropertySource<?>> getPropertySources(String location) {
        GenericXmlApplicationContext context = new GenericXmlApplicationContext(new String[]{location});
        List<PropertySource<?>> sources = this.getPropertySources((ConfigurableApplicationContext)context);
        this.closeQuietly((ConfigurableApplicationContext)context);
        return sources;
    }

    @Override
    public List<PropertySource<?>> getPropertySources(ConfigurableApplicationContext context) {
        Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, PropertySource.class);
        ArrayList list = new ArrayList();
        for (PropertySource source : map.values()) {
            list.add(source);
        }
        return list;
    }

    @Override
    public void load(Class<?> annotatedClass) {
        this.load(annotatedClass, null, null);
    }

    @Override
    public void load(Class<?> annotatedClass, String beanName, Object bean, PropertySource<?> propertySource) {
        Assert.notNull(annotatedClass);
        ArrayList annotatedClasses = new ArrayList();
        annotatedClasses.add(annotatedClass);
        ArrayList propertySources = new ArrayList();
        if (propertySource != null) {
            propertySources.add(propertySource);
        }
        SpringContext context = new SpringContext();
        context.setAnnotatedClasses(annotatedClasses);
        context.setPropertySources(propertySources);
        context.setBeanNames(CollectionUtils.toEmptyList(beanName));
        context.setBeans(CollectionUtils.toEmptyList(bean));
        this.load(context);
    }

    @Override
    public void load(Class<?> annotatedClass, String beanName, Object bean) {
        this.load(annotatedClass, beanName, bean, null);
    }

    @Override
    public void load(String location) {
        this.load(location, null, null);
    }

    @Override
    public void load(String location, String beanName, Object bean, PropertySource<?> propertySource) {
        Assert.hasText((String)location);
        ArrayList propertySources = new ArrayList();
        if (propertySource != null) {
            propertySources.add(propertySource);
        }
        SpringContext context = new SpringContext();
        context.setLocations(Arrays.asList(location));
        context.setPropertySources(propertySources);
        context.setBeanNames(CollectionUtils.toEmptyList(beanName));
        context.setBeans(CollectionUtils.toEmptyList(bean));
        this.load(context);
    }

    @Override
    public void load(String location, String beanName, Object bean) {
        this.load(location, beanName, bean, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(SpringContext context) {
        context.setBeanNames(CollectionUtils.toEmptyList(context.getBeanNames()));
        context.setBeans(CollectionUtils.toEmptyList(context.getBeans()));
        context.setAnnotatedClasses(CollectionUtils.toEmptyList(context.getAnnotatedClasses()));
        context.setLocations(CollectionUtils.toEmptyList(context.getLocations()));
        boolean notEmpty = !CollectionUtils.isEmpty(context.getLocations()) || !CollectionUtils.isEmpty(context.getAnnotatedClasses());
        Assert.isTrue((boolean)notEmpty, (String)"Both locations and annotatedClasses are empty");
        Assert.isTrue((context.getBeanNames().size() == context.getBeans().size() ? 1 : 0) != 0);
        this.validate(context.getLocations());
        List<String> convertedLocations = this.getConvertedLocations(context.getLocations());
        String[] locationsArray = CollectionUtils.toStringArray(convertedLocations);
        ConfigurableApplicationContext parent = null;
        ClassPathXmlApplicationContext xmlChild = null;
        AnnotationConfigApplicationContext annotationChild = null;
        try {
            if (this.isParentContextRequired(context)) {
                parent = this.getContextWithPreRegisteredBeans(context.getBeanNames(), context.getBeans());
            }
            if (!CollectionUtils.isEmpty(context.getAnnotatedClasses())) {
                annotationChild = this.getAnnotationContext(context, parent);
                this.addPropertySources(context, (ConfigurableApplicationContext)annotationChild);
            }
            if (!CollectionUtils.isEmpty(context.getLocations())) {
                xmlChild = new ClassPathXmlApplicationContext(locationsArray, false, (ApplicationContext)parent);
                this.addPropertySources(context, (ConfigurableApplicationContext)xmlChild);
            }
            this.refreshQuietly((ConfigurableApplicationContext)annotationChild);
            this.refreshQuietly((ConfigurableApplicationContext)xmlChild);
            this.closeQuietly((ConfigurableApplicationContext)annotationChild);
            this.closeQuietly((ConfigurableApplicationContext)xmlChild);
            this.closeQuietly(parent);
        }
        catch (Throwable throwable) {
            this.closeQuietly((ConfigurableApplicationContext)annotationChild);
            this.closeQuietly((ConfigurableApplicationContext)xmlChild);
            this.closeQuietly(parent);
            throw throwable;
        }
    }

    protected AnnotationConfigApplicationContext getAnnotationContext(SpringContext context, ConfigurableApplicationContext parent) {
        AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();
        if (parent != null) {
            ctx.setParent((ApplicationContext)parent);
        }
        for (Class<?> annotatedClass : context.getAnnotatedClasses()) {
            ctx.register(new Class[]{annotatedClass});
        }
        return ctx;
    }

    protected void refreshQuietly(ConfigurableApplicationContext context) {
        if (context != null) {
            context.refresh();
        }
    }

    protected void closeQuietly(ConfigurableApplicationContext context) {
        if (context != null) {
            context.close();
        }
    }

    @Override
    public ConfigurableApplicationContext getContextWithPreRegisteredBeans(List<String> beanNames, List<Object> beans) {
        Assert.isTrue((beanNames.size() == beans.size() ? 1 : 0) != 0);
        GenericXmlApplicationContext appContext = new GenericXmlApplicationContext();
        appContext.refresh();
        ConfigurableListableBeanFactory factory = appContext.getBeanFactory();
        for (int i = 0; i < beanNames.size(); ++i) {
            String beanName = beanNames.get(i);
            Object bean = beans.get(i);
            logger.debug("Registering bean - [{}] -> [{}]", (Object)beanName, (Object)bean.getClass().getName());
            factory.registerSingleton(beanName, bean);
        }
        return appContext;
    }

    @Override
    public ConfigurableApplicationContext getContextWithPreRegisteredBean(String beanName, Object bean) {
        return this.getContextWithPreRegisteredBeans(Arrays.asList(beanName), Arrays.asList(bean));
    }

    protected void addPropertySources(SpringContext context, ConfigurableApplicationContext applicationContext) {
        if (CollectionUtils.isEmpty(context.getPropertySources())) {
            return;
        }
        List<PropertySource<?>> propertySources = context.getPropertySources();
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        MutablePropertySources sources = environment.getPropertySources();
        if (context.isLastOneInWins()) {
            Collections.reverse(propertySources);
        }
        for (PropertySource<?> propertySource : propertySources) {
            logger.debug("Adding property source - [{}] -> [{}]", (Object)propertySource.getName(), (Object)propertySource.getClass().getName());
            sources.addLast(propertySource);
        }
    }

    protected boolean isParentContextRequired(SpringContext context) {
        if (!CollectionUtils.isEmpty(context.getBeanNames())) {
            return true;
        }
        return !CollectionUtils.isEmpty(context.getBeans());
    }

    protected void validate(List<String> locations) {
        StringBuilder sb = new StringBuilder();
        for (String location : locations) {
            if (LocationUtils.exists(location)) continue;
            sb.append("Location [" + location + "] does not exist\n");
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException(sb.toString());
        }
    }

    protected List<String> getConvertedLocations(List<String> locations) {
        ArrayList<String> converted = new ArrayList<String>();
        for (String location : locations) {
            if (LocationUtils.isExistingFile(location)) {
                File file = new File(location);
                String url = LocationUtils.getCanonicalURLString(file);
                converted.add(url);
                continue;
            }
            converted.add(location);
        }
        return converted;
    }
}

