/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.execute.StorePropertiesExecutable;
import org.kuali.common.util.spring.SpringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

@Configuration
public class MetaInfProjectPropertiesConfig {
    @Autowired
    ConfigurableEnvironment env;
    @Value(value="${project.build.outputDirectory}/META-INF/${project.groupId.path}/${project.artifactId}.properties")
    File outputFile;

    @Bean
    public static PropertySourcesPlaceholderConfigurer pspc() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    public Properties springProperties() {
        return SpringUtils.getAllEnumerableProperties(this.env);
    }

    @Bean(initMethod="execute")
    public Executable storePropertiesExecutable() {
        String encoding = SpringUtils.getProperty((Environment)this.env, "project.encoding");
        String includesCSV = SpringUtils.getProperty((Environment)this.env, "project.metainf.includes");
        String excludesCSV = SpringUtils.getProperty((Environment)this.env, "project.metainf.excludes");
        Assert.hasText((String)encoding);
        Assert.hasText((String)includesCSV);
        Assert.hasText((String)excludesCSV);
        List<String> includes = CollectionUtils.getTrimmedListFromCSV(includesCSV);
        List<String> excludes = CollectionUtils.getTrimmedListFromCSV(excludesCSV);
        Properties properties = this.springProperties();
        StorePropertiesExecutable spe = new StorePropertiesExecutable();
        spe.setEncoding(encoding);
        spe.setOutputFile(this.outputFile);
        spe.setProperties(properties);
        spe.setIncludes(includes);
        spe.setExcludes(excludes);
        return spe;
    }
}

