/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import org.codehaus.plexus.util.StringUtils;
import org.kuali.common.util.service.ScmService;
import org.kuali.common.util.service.ScmType;
import org.kuali.common.util.service.SubversionService;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;

public class ScmServiceFactoryBean
implements FactoryBean<ScmService> {
    String url;

    public ScmService getObject() throws Exception {
        Assert.notNull((Object)this.url, (String)"URL is null");
        String[] tokens = StringUtils.split((String)this.url, (String)":");
        String scmType = tokens[1].toUpperCase();
        ScmType type = ScmType.valueOf(scmType);
        switch (type) {
            case SVN: {
                return new SubversionService();
            }
            case GIT: {
                throw new IllegalArgumentException("GIT support is coming soon!");
            }
        }
        throw new IllegalArgumentException("SCM type [" + scmType + "] is unknown");
    }

    public Class<ScmService> getObjectType() {
        return ScmService.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

