/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class SpringUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpringUtils.class);

    public static void showPropertySources(ConfigurableEnvironment env) {
        List<PropertySource<?>> propertySources = SpringUtils.getPropertySources(env);
        for (PropertySource<?> propertySource : propertySources) {
            String name = propertySource.getName();
            String impl = propertySource.getClass().getName();
            String source = propertySource.getSource().getClass().getName();
            Object[] args = new Object[]{name, impl, source};
            logger.info("Name: {}  Impl: [{}]  Source: [{}]", args);
        }
    }

    public static String getProperty(Environment env, String key) {
        String value = env.getRequiredProperty(key);
        return env.resolveRequiredPlaceholders(value);
    }

    public static Properties getAllEnumerableProperties(ConfigurableEnvironment env) {
        List<PropertySource<?>> sources = SpringUtils.getPropertySources(env);
        List<Properties> propertiesList = SpringUtils.convertEnumerablePropertySources(sources);
        Collections.reverse(propertiesList);
        return PropertyUtils.combine(propertiesList);
    }

    public static void reconfigurePropertySources(ConfigurableEnvironment env, String name, Properties properties) {
        SpringUtils.removeAllPropertySources(env);
        MutablePropertySources mps = env.getPropertySources();
        Assert.isTrue((mps.size() == 0 ? 1 : 0) != 0);
        PropertiesPropertySource pps = new PropertiesPropertySource(name, properties);
        mps.addFirst((PropertySource)pps);
    }

    public static void removeAllPropertySources(ConfigurableEnvironment env) {
        MutablePropertySources mps = env.getPropertySources();
        List<PropertySource<?>> sources = SpringUtils.getPropertySources(env);
        for (PropertySource<?> source : sources) {
            String name = source.getName();
            mps.remove(name);
        }
    }

    public static List<PropertySource<?>> getPropertySources(ConfigurableEnvironment env) {
        MutablePropertySources mps = env.getPropertySources();
        ArrayList sources = new ArrayList();
        for (PropertySource source : mps) {
            sources.add(source);
        }
        return sources;
    }

    public static List<Properties> convertEnumerablePropertySources(List<PropertySource<?>> sources) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        for (PropertySource<?> source : sources) {
            logger.debug("Adding [{}]", (Object)source.getName());
            if (source instanceof EnumerablePropertySource) {
                EnumerablePropertySource eps = (EnumerablePropertySource)source;
                Properties sourceProperties = SpringUtils.convert(eps);
                list.add(sourceProperties);
                continue;
            }
            logger.warn("Unable to obtain properties from property source [{}] -> [{}]", (Object)source.getName(), (Object)source.getClass().getName());
        }
        return list;
    }

    public static Properties convert(EnumerablePropertySource<?> source) {
        String[] names;
        Properties properties = new Properties();
        for (String name : names = source.getPropertyNames()) {
            Object object = source.getProperty(name);
            if (object != null) {
                String value = object.toString();
                properties.setProperty(name, value);
                continue;
            }
            logger.warn("Property [{}] is null", (Object)name);
        }
        return properties;
    }
}

