/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.condition;

import java.util.Date;

import com.google.common.base.Preconditions;

/**
 * @deprecated use AfterCondition instead
 */
@Deprecated
public final class AfterDateCondition implements Condition {

	private final AfterTimeCondition condition;

	public AfterDateCondition(Date targetDate) {
		Preconditions.checkNotNull(targetDate, "'targetDate' cannot be null");
		this.condition = new AfterTimeCondition(targetDate.getTime());
	}

	@Override
	public boolean isTrue() {
		return condition.isTrue();
	}

	public Date getTargetDate() {
		return new Date(condition.getTargetTimeInMillis());
	}

}
