/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.condition;

import java.util.Date;

import com.google.common.base.Preconditions;

public final class BeforeCondition implements Condition {

	public BeforeCondition(Date date) {
		this(date.getTime());
	}

	public BeforeCondition(long millis) {
		Preconditions.checkArgument(millis >= 0, "'millis' must be >= 0");
		this.millis = millis;
	}

	private final long millis;

	@Override
	public boolean isTrue() {
		return System.currentTimeMillis() < millis;
	}

	public long getMillis() {
		return millis;
	}

	public Date getDate() {
		return new Date(millis);
	}

}
