/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;

/**
 * A <code>CanonicalFile</code> is always both absolute and unique.
 */
public final class CanonicalFile extends File {

	private static final long serialVersionUID = -8366640724070158688L;

	/**
	 * A <code>CanonicalFile</code> is always both absolute and unique.
	 */
	public CanonicalFile(File parent, String child) {
		this(new File(parent, child));
	}

	/**
	 * A <code>CanonicalFile</code> is always both absolute and unique.
	 */
	public CanonicalFile(String parent, String child) {
		this(new File(parent, child));
	}

	/**
	 * A <code>CanonicalFile</code> is always both absolute and unique.
	 */
	public CanonicalFile(URI uri) {
		this(new File(uri));
	}

	/**
	 * A <code>CanonicalFile</code> is always both absolute and unique.
	 */
	public CanonicalFile(String path) {
		this(new File(path));
	}

	/**
	 * A <code>CanonicalFile</code> is always both absolute and unique.
	 */
	public CanonicalFile(File file) {
		super(getCanonicalPath(file));
	}

	/**
	 * Return the current working directory.
	 */
	public static final CanonicalFile cwd() {
		return new CanonicalFile(".");
	}

	protected static String getCanonicalPath(File file) {
		try {
			return file.getCanonicalPath();
		} catch (IOException e) {
			throw new IllegalStateException("unexpected io error", e);
		}
	}

}
