/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.log.log4j;

import java.io.File;

import org.kuali.common.util.file.CanonicalFile;
import org.kuali.common.util.log.log4j.model.Param;
import org.kuali.common.util.log.log4j.model.Threshold;

public class ParamFactory {

	public static final String CONVERSION_PATTERN = "ConversionPattern";
	public static final String FILE = "File";
	public static final String THRESHOLD = "Threshold";

	public static Param getPatternParam(String pattern) {
		return new Param(CONVERSION_PATTERN, pattern);
	}

	public static Param getFileParam(String filename) {
		return new Param(FILE, filename);
	}

	public static Param getFileParam(File file) {
		return getFileParam(new CanonicalFile(file).getPath());
	}

	public static Param getThresholdParam(Threshold threshold) {
		return new Param(THRESHOLD, threshold.name());
	}

}
