/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.log.log4j.jaxb;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.kuali.common.util.log.log4j.model.Debug;

public class DebugAdapter extends XmlAdapter<String, Debug> {

	@Override
	public final String marshal(Debug value) {
		if (Debug.DEFAULT_VALUE.equals(value)) {
			return null;
		} else {
			return value.name().toLowerCase();
		}
	}

	@Override
	public final Debug unmarshal(String value) {
		if (value == null) {
			return Debug.DEFAULT_VALUE;
		} else {
			return Debug.valueOf(value.toUpperCase());
		}
	}

}
