/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.log.log4j.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

import org.kuali.common.util.Assert;
import org.kuali.common.util.nullify.NullUtils;

public final class Appender {

	public static final List<Appender> EMPTY = Collections.<Appender> emptyList();
	public static final Class<? extends org.apache.log4j.Appender> NO_APPENDER_CLASS = org.apache.log4j.Appender.class;
	public static final Appender NONE = new Appender();

	@XmlAttribute
	private final String name;

	@XmlAttribute(name = "class")
	private final Class<? extends org.apache.log4j.Appender> appenderClass;

	@XmlElement(name = "param")
	private final List<Param> params;

	@XmlElement
	private final Layout layout;

	private Appender() {
		this(NullUtils.NONE, NO_APPENDER_CLASS, Layout.NONE, Param.EMPTY);
	}

	public Appender(String name, Class<? extends org.apache.log4j.Appender> appenderClass, Layout layout) {
		this(name, appenderClass, layout, Param.EMPTY);
	}

	public Appender(String name, Class<? extends org.apache.log4j.Appender> appenderClass, Layout layout, List<Param> params) {
		Assert.noNulls(appenderClass, layout, params);
		Assert.noBlanks(name);
		this.name = name;
		this.appenderClass = appenderClass;
		this.layout = layout;
		this.params = new ArrayList<Param>(params);
	}

	public List<Param> getParams() {
		return Collections.unmodifiableList(params);
	}

	public String getName() {
		return name;
	}

	public Class<? extends org.apache.log4j.Appender> getAppenderClass() {
		return appenderClass;
	}

	public Layout getLayout() {
		return layout;
	}

}
