/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.log.log4j.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.nullify.Null;

public final class Layout {

	public static final Layout NONE = new Layout();

	@XmlAttribute(name = "class")
	private final Class<?> layoutClass;

	@XmlElement(name = "param")
	private final List<Param> params;

	private Layout() {
		this(Null.class, Param.EMPTY);
	}

	public Layout(Class<?> layoutClass, Param param) {
		this(layoutClass, CollectionUtils.singletonList(param));
	}

	public Layout(Class<?> layoutClass, List<Param> params) {
		Assert.noNulls(layoutClass, params);
		this.layoutClass = layoutClass;
		this.params = new ArrayList<Param>(params);
	}

	public List<Param> getParams() {
		return Collections.unmodifiableList(params);
	}

	public Class<?> getLayoutClass() {
		return layoutClass;
	}

}
