/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.main;

import org.kuali.common.util.Assert;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.execute.Executable;

/**
 * Validate <code>String[] args</code> is not null, contains at least one non-blank value and points to a location that exists.
 */
public final class ValidatePropertiesLocationExecutable implements Executable {

	public ValidatePropertiesLocationExecutable(MainContext context, String message) {
		Assert.noNulls(context);
		Assert.noBlanks(message);
		this.context = context;
		this.message = message;
	}

	private final String message;
	private final MainContext context;

	@Override
	public void execute() {
		String[] args = context.getArgs();
		Assert.notNull(args, message);
		Assert.isTrue(args.length > 0, message);
		String location = args[0];
		Assert.noBlanks(message, location);
		LocationUtils.validateLocation(location, message);
	}

	public String getMessage() {
		return message;
	}

	public MainContext getContext() {
		return context;
	}

}
