/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.maven.spring;

import java.io.File;

import org.kuali.common.util.maven.DefaultLocalRepositoryService;
import org.kuali.common.util.maven.LocalRepositoryService;
import org.kuali.common.util.maven.RepositoryUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import({ SpringServiceConfig.class })
public class MavenServiceConfig {

	private static final String LOCAL_REPO_KEY = "settings.localRepository";

	@Autowired
	EnvironmentService env;

	@Bean
	public LocalRepositoryService localRepositoryService() {
		File defaultLocalRepo = RepositoryUtils.getDefaultLocalRepository();
		File localRepository = env.getFile(LOCAL_REPO_KEY, defaultLocalRepo);
		return new DefaultLocalRepositoryService(localRepository);
	}

}
