/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.project.model;

import static org.kuali.common.util.project.KualiProjectConstants.KUALI_COMMON_GROUP_ID;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.kuali.common.util.Assert;
import org.kuali.common.util.project.KualiProjectConstants;

/**
 * @deprecated
 */
@Deprecated
public enum KualiGroup {

	COMMON(KUALI_COMMON_GROUP_ID), //
	/**
	 * @deprecated
	 */
	@Deprecated
	RICE(KualiProjectConstants.RICE_GROUP_ID), //
	/**
	 * @deprecated
	 */
	@Deprecated
	STUDENT(KualiProjectConstants.STUDENT_GROUP_ID), //
	/**
	 * @deprecated
	 */
	@Deprecated
	MOBILITY(KualiProjectConstants.MOBILITY_GROUP_ID), //
	/**
	 * @deprecated
	 */
	@Deprecated
	OLE(KualiProjectConstants.OLE_GROUP_ID), //
	/**
	 * @deprecated
	 */
	@Deprecated
	KFS(KualiProjectConstants.KFS_GROUP_ID), //
	/**
	 * @deprecated
	 */
	@Deprecated
	COEUS(KualiProjectConstants.COEUS_GROUP_ID), //
	/**
	 * @deprecated
	 */
	@Deprecated
	READY(KualiProjectConstants.READY_GROUP_ID), //
	/**
	 * @deprecated
	 */
	@Deprecated
	KPME(KualiProjectConstants.KPME_GROUP_ID);

	private KualiGroup(String groupId) {
		Assert.noBlanks(groupId);
		this.id = groupId;
	}

	private final String id;

	public String getId() {
		return id;
	}

	/**
	 * Return the Kuali groups as an immutable list
	 */
	public static final List<KualiGroup> asList() {
		return Collections.unmodifiableList(Arrays.asList(values()));
	}

}
