/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.properties;

import java.util.Properties;

import org.kuali.common.util.Assert;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.ModeUtils;
import org.kuali.common.util.PropertyUtils;

public final class LocationLoader implements PropertiesLoader {

	private final String value;
	private final Location location;

	public LocationLoader(Location location) {
		this(location, location.getValue());
	}

	public LocationLoader(Location location, String value) {
		Assert.noNulls(location);
		Assert.noBlanks(value);
		this.value = value;
		this.location = location;
	}

	@Override
	public Properties load() {
		if (!LocationUtils.exists(value)) {
			// Take appropriate action for missing locations (ignore, inform, warn, or error out)
			ModeUtils.validate(location.getMissingMode(), "Non-existent location [" + value + "]");
			return PropertyUtils.EMPTY;
		} else {
			return PropertyUtils.load(value, location.getEncoding(), location.getFormat());
		}
	}

	public String getValue() {
		return value;
	}

	public Location getLocation() {
		return location;
	}

}
