/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.spring.service;

import org.kuali.common.util.spring.env.BasicEnvironmentService;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.env.model.EnvironmentServiceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SpringServiceConfig {

	@Autowired
	Environment env;

	@Bean
	public SpringService springService() {
		return new DefaultSpringService();
	}

	@Bean
	public PropertySourceService propertySourceService() {
		return new DefaultPropertySourceService(springService());
	}

	@Bean
	public EnvironmentService environmentService() {
		EnvironmentServiceContext context = new EnvironmentServiceContext.Builder().env(env).build();
		return new BasicEnvironmentService(context);
	}
}
