/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.xml.jaxb.adapter;

import java.util.Collection;
import java.util.Collections;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.kuali.common.util.xml.jaxb.wrapper.CollectionWrapper;

public class ImmutableCollectionAdapter<T> extends XmlAdapter<CollectionWrapper<T>, Collection<T>> {

	private final Collection<T> EMPTY_COLLECTION = Collections.emptyList();
	private final CollectionWrapper<T> EMPTY_WRAPPER = new CollectionWrapper<T>(EMPTY_COLLECTION);

	@Override
	public CollectionWrapper<T> marshal(Collection<T> c) {
		if (isEmpty(c)) {
			return EMPTY_WRAPPER;
		} else {
			return new CollectionWrapper<T>(c);
		}
	}

	@Override
	public Collection<T> unmarshal(CollectionWrapper<T> wrapper) {
		if (isEmpty(wrapper.getCollection())) {
			return EMPTY_COLLECTION;
		} else {
			return Collections.unmodifiableCollection(wrapper.getCollection());
		}
	}

	protected static boolean isEmpty(Collection<?> c) {
		return c == null || c.size() == 0;
	}

}
