/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.xml.spring;

import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.kuali.common.util.xml.jaxb.JAXBXmlService;
import org.kuali.common.util.xml.service.XmlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import({ SpringServiceConfig.class })
public class XmlServiceConfig {

	private static final String FORMAT_OUTPUT_KEY = "jaxb.formatOutput";
	private static final String USE_NAMESPACE_AWARE_PARSER_KEY = "jaxb.useNamespaceAwareParser";
	private static final String USE_ECLIPSE_LINK_MOXY_PROVIDER_KEY = "jaxb.useEclipseLinkMoxyProvider";

	@Autowired
	EnvironmentService env;

	@Bean
	public XmlService xmlService() {
		boolean formatOutput = env.getBoolean(FORMAT_OUTPUT_KEY, JAXBXmlService.Builder.FORMAT_OUTPUT);
		boolean nap = env.getBoolean(USE_NAMESPACE_AWARE_PARSER_KEY, JAXBXmlService.Builder.USE_NAMESPACE_AWARE_PARSER);
		boolean elmp = env.getBoolean(USE_ECLIPSE_LINK_MOXY_PROVIDER_KEY, JAXBXmlService.Builder.USE_ECLIPSE_LINK_MOXY_PROVIDER);
		return JAXBXmlService.builder().formatOutput(formatOutput).useNamespaceAwareParser(nap).useEclipseLinkMoxyProvider(elmp).build();
	}
}
