/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.enc;

import java.util.Properties;

/**
 * @deprecated 
 */
@Deprecated
public interface EncryptionService {

	/**
	 * Encrypt the text and prefix it with <code>enc--</code>. If the text is already encrypted, do nothing.
	 * 
	 * <pre>
	 *   foo -> x7UiXya -> enc--x7UiXya
	 * </pre>
	 */
	String encrypt(String plainText);

	/**
	 * Remove the <code>enc--</code> prefix and then decrypt it. If the text is not encrypted, do nothing.
	 * 
	 * <pre>
	 *   enc--x7UiXya -> x7UiXya -> foo
	 * </pre>
	 */
	String decrypt(String encryptedText);

	/**
	 * Detect any encrypted property values and decrypt them
	 */
	void decrypt(Properties properties);

	/**
	 * Encrypt any property values that are not already encrypted.
	 */
	void encrypt(Properties properties);

}
