/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.log.log4j.jaxb;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.kuali.common.util.log.log4j.model.Threshold;

public class RepositoryThresholdAdapter extends XmlAdapter<String, Threshold> {

	@Override
	public final String marshal(Threshold threshold) {
		if (Threshold.DEFAULT_REPOSITORY_VALUE.equals(threshold)) {
			return null;
		} else {
			return threshold.name().toLowerCase();
		}
	}

	@Override
	public final Threshold unmarshal(String threshold) {
		if (threshold == null) {
			return Threshold.DEFAULT_REPOSITORY_VALUE;
		} else {
			return Threshold.valueOf(threshold.toUpperCase());
		}
	}

}
