/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.maven;

import static org.kuali.common.util.base.Precondition.checkNotNull;
import static org.kuali.common.util.maven.RepositoryUtils.getDefaultLocalRepository;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.kuali.common.util.file.CanonicalFile;
import org.kuali.common.util.maven.model.Artifact;

public final class DefaultLocalRepositoryService implements LocalRepositoryService {

	private final File localRepository;

	public DefaultLocalRepositoryService() {
		this(getDefaultLocalRepository());
	}

	public DefaultLocalRepositoryService(File localRepository) {
		this.localRepository = new CanonicalFile(checkNotNull(localRepository, "localRepository"));
	}

	@Override
	public List<File> getFiles(List<Artifact> artifacts) {
		List<File> files = new ArrayList<File>();
		for (Artifact artifact : artifacts) {
			File file = getFile(artifact);
			files.add(file);
		}
		return files;
	}

	@Override
	public File getFile(Artifact artifact) {
		return RepositoryUtils.getFile(localRepository, artifact);
	}

	@Override
	public File getLocalRepository() {
		return localRepository;
	}

}
