/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.project.model;

import org.kuali.common.util.Assert;
import org.kuali.common.util.ObjectUtils;
import org.kuali.common.util.identify.Identifiable;

/**
 * @deprecated
 */
@Deprecated
public final class FeatureIdentifier implements Identifiable {

	private final ProjectIdentifier project;
	private final String featureId;

	private final String identifier;
	private final int hashCode;

	public FeatureIdentifier(ProjectIdentifier project, String featureId) {
		// Make sure we are being configured correctly
		Assert.noNulls(project);
		Assert.noBlanks(featureId);

		// Finish setting things up
		this.project = project;
		this.featureId = featureId;
		this.identifier = project.getIdentifier() + ":" + featureId;
		this.hashCode = identifier.hashCode();
	}

	public FeatureIdentifier(String groupId, String artifactId, String featureId) {
		this(new ProjectIdentifier(groupId, artifactId), featureId);
	}

	public ProjectIdentifier getProject() {
		return project;
	}

	public String getFeatureId() {
		return featureId;
	}

	@Override
	public String getIdentifier() {
		return identifier;
	}

	@Override
	public String toString() {
		return identifier;
	}

	@Override
	public int hashCode() {
		return hashCode;
	}

	@Override
	public boolean equals(Object object) {
		return ObjectUtils.equalsByToString(this, object);
	}

}
