/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.spring.env;

import org.kohsuke.MetaInfServices;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

/**
 * This environment contains both system properties and environment variables and automatically checks both whenever a property is requested.
 * 
 * <pre>
 *   foo.barBaz -> env.FOO_BAR_BAZ
 *                 FOO_BAR_BAZ
 *                 env.foo_bar_baz
 *                 foo_bar_baz
 * </pre>
 */
@MetaInfServices(Environment.class)
public class SysEnvEnvironment extends AbstractEnvironment {

	public SysEnvEnvironment() {
		PropertySource<?> source = new SysEnvPropertySource();
		MutablePropertySources sources = super.getPropertySources();
		sources.addFirst(source);
	}

}
