/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.xml.jaxb.adapter;

import java.util.Collections;
import java.util.Map;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.kuali.common.util.xml.jaxb.wrapper.MapWrapper;

public class ImmutableMapAdapter<K, V> extends XmlAdapter<MapWrapper<K, V>, Map<K, V>> {

	private final Map<K, V> EMPTY_MAP = Collections.emptyMap();
	private final MapWrapper<K, V> EMPTY_WRAPPER = new MapWrapper<K, V>(EMPTY_MAP);

	@Override
	public MapWrapper<K, V> marshal(Map<K, V> map) {
		if (isEmpty(map)) {
			return EMPTY_WRAPPER;
		} else {
			return new MapWrapper<K, V>(map);
		}
	}

	@Override
	public Map<K, V> unmarshal(MapWrapper<K, V> wrapper) {
		if (isEmpty(wrapper.getMap())) {
			return EMPTY_MAP;
		} else {
			return Collections.unmodifiableMap(wrapper.getMap());
		}
	}

	protected static boolean isEmpty(Map<?, ?> map) {
		return map == null || map.size() == 0;
	}

}
