/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

public final class Ascii {
    private static final int LETTER_OFFSET = 13;
    private static final int NUMBER_OFFSET = 5;
    private static final char NUMBER_MIDPOINT = '4';
    private static final char LCASE_MIDPOINT = 'm';
    private static final char UCASE_MIDPOINT = 'M';

    private Ascii() {
    }

    public static boolean isLetter(char c) {
        return Ascii.isLowerCase(c) || Ascii.isUpperCase(c);
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static char flip(char c) {
        if (Ascii.isLowerCase(c)) {
            if (c > 'm') {
                return (char)(c - 13);
            }
            return (char)(c + 13);
        }
        if (Ascii.isUpperCase(c)) {
            if (c > 'M') {
                return (char)(c - 13);
            }
            return (char)(c + 13);
        }
        if (Ascii.isDigit(c)) {
            if (c > '4') {
                return (char)(c - 5);
            }
            return (char)(c + 5);
        }
        return c;
    }
}

