/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.enc.EncUtils;

public abstract class Assert
extends org.springframework.util.Assert {
    private static final String NO_NULLS = "null not allowed";
    private static final String NO_BLANKS = "blank strings not allowed";

    public static void present(Optional<?> optional) {
        Assert.present(optional, "optional value is required");
    }

    public static void present(Optional<?> optional, String msg) {
        Assert.isTrue((boolean)optional.isPresent());
    }

    public static void concealed(String text) {
        Assert.isTrue((boolean)Str.isConcealed(text), (String)"text must be concealed");
    }

    public static void notConcealed(String text) {
        Assert.isFalse(Str.isConcealed(text), "text is already concealed");
    }

    @Deprecated
    public static void encrypted(String text) {
        Assert.isTrue((boolean)EncUtils.isEncrypted(text), (String)"text must be encrypted");
    }

    @Deprecated
    public static void notEncrypted(String text) {
        Assert.isFalse(EncUtils.isEncrypted(text), "text is already encrypted");
    }

    @Deprecated
    public static void decrypted(String text) {
        Assert.notEncrypted(text);
    }

    @Deprecated
    public static void decrypted(List<String> strings) {
        Assert.notEncrypted(strings);
    }

    public static void notEncrypted(List<String> strings) {
        for (String string : strings) {
            Assert.notEncrypted(string);
        }
    }

    public static void isPort(int port) {
        Assert.isTrue((port >= 0 && port <= 65535 ? 1 : 0) != 0, (String)"Port must be a number between 0 and 65535");
    }

    public static void noNegatives(int ... numbers) {
        for (int number : numbers) {
            Assert.notNegative(number);
        }
    }

    public static void noNegatives(long ... numbers) {
        for (long number : numbers) {
            Assert.notNegative(number);
        }
    }

    public static void noPositives(int ... numbers) {
        for (int number : numbers) {
            Assert.notPositive(number);
        }
    }

    public static void notNegative(int i) {
        Assert.isTrue((i >= 0 ? 1 : 0) != 0, (String)(i + " is negative"));
    }

    public static void notNegative(long i) {
        Assert.isTrue((i >= 0L ? 1 : 0) != 0, (String)(i + " is negative"));
    }

    public static void notPositive(int i) {
        Assert.isTrue((i <= 0 ? 1 : 0) != 0, (String)(i + " is positive"));
    }

    public static void positive(int i) {
        Assert.isTrue((i > 0 ? 1 : 0) != 0, (String)(i + " is not a positive integer"));
    }

    public static void positive(long i) {
        Assert.isTrue((i > 0L ? 1 : 0) != 0, (String)(i + " is not a positive long"));
    }

    public static void negative(int i) {
        Assert.isTrue((i < 0 ? 1 : 0) != 0, (String)(i + " is not a negative integer"));
    }

    public static void zero(int i) {
        Assert.isTrue((i == 0 ? 1 : 0) != 0, (String)(i + " is not zero"));
    }

    public static void exists(String location) {
        Assert.exists(location, "[" + location + "] does not exist");
    }

    public static void exists(String location, String message) {
        Assert.isTrue((boolean)LocationUtils.exists(location), (String)message);
    }

    public static void isExistingDir(File dir) {
        Assert.isExistingDir(dir, "[" + dir + "] is not an existing directory");
    }

    public static void isExistingDir(File dir, String message) {
        Assert.exists(dir, message);
        Assert.isTrue((boolean)dir.isDirectory(), (String)message);
    }

    public static void exists(File file) {
        Assert.exists(file, "[" + file + "] does not exist");
    }

    public static void exists(File file, String message) {
        Assert.isTrue((boolean)file.exists(), (String)message);
    }

    public static void isOdd(int i) {
        Assert.isOdd(i, "[" + i + "] is not an odd number");
    }

    public static void isOdd(int i, String message) {
        Assert.isTrue((i % 2 != 0 ? 1 : 0) != 0, (String)message);
    }

    public static void isEven(int i) {
        Assert.isEven(i, "[" + i + "] is not an even number");
    }

    public static void isEven(int i, String message) {
        Assert.isTrue((i % 2 == 0 ? 1 : 0) != 0, (String)message);
    }

    public static void isFalse(boolean condition) {
        Assert.isTrue((!condition ? 1 : 0) != 0);
    }

    public static void isFalse(boolean condition, String message) {
        Assert.isTrue((!condition ? 1 : 0) != 0, (String)message);
    }

    public static void notBlank(String string) {
        Assert.isFalse(StringUtils.isBlank((CharSequence)string));
    }

    public static void noBlanks(String ... strings) {
        Assert.noBlanksWithMsg(NO_BLANKS, strings);
    }

    public static void present(Optional<?> ... optionals) {
        for (Optional<?> optional : optionals) {
            Assert.isTrue((boolean)optional.isPresent(), (String)"Optional is required");
        }
    }

    public static void noBlanks(Optional<String> string) {
        Assert.noBlankOptionals((List<Optional<String>>)ImmutableList.of(string));
    }

    public static void noBlanks(Optional<String> s1, Optional<String> s2) {
        Assert.noBlankOptionals((List<Optional<String>>)ImmutableList.of(s1, s2));
    }

    public static void noBlanks(Optional<String> s1, Optional<String> s2, Optional<String> s3) {
        Assert.noBlankOptionals((List<Optional<String>>)ImmutableList.of(s1, s2, s3));
    }

    public static void noBlanks(Optional<String> s1, Optional<String> s2, Optional<String> s3, Optional<String> s4) {
        Assert.noBlankOptionals((List<Optional<String>>)ImmutableList.of(s1, s2, s3, s4));
    }

    public static void noBlankOptionals(List<Optional<String>> optionals) {
        for (Optional<String> optional : optionals) {
            if (!optional.isPresent()) continue;
            Assert.noBlanks((String)optional.get());
        }
    }

    @Deprecated
    @SafeVarargs
    public static void noBlanksIfPresent(Optional<String> ... optionals) {
        for (Optional<String> optional : optionals) {
            if (!optional.isPresent()) continue;
            Assert.noBlanks((String)optional.get());
        }
    }

    public static void noBlanks(List<String> strings) {
        Assert.noNulls(strings);
        for (String string : strings) {
            Assert.noBlanksWithMsg(NO_BLANKS, string);
        }
    }

    public static void noNullStrings(String ... strings) {
        Assert.notNull((Object)strings);
        for (String string : strings) {
            Assert.notNull((Object)string, (String)NO_NULLS);
        }
    }

    public static void noNulls(Object ... objects) {
        Assert.noNullsWithMsg(NO_NULLS, objects);
    }

    public static void noNullsWithMsg(String msg, Object ... objects) {
        for (Object object : objects) {
            Assert.notNull((Object)object, (String)msg);
        }
    }

    public static void noBlanksWithMsg(String msg, String ... strings) {
        for (String string : strings) {
            Assert.isFalse(StringUtils.isBlank((CharSequence)string), msg);
        }
    }

    @Deprecated
    public static void notNull(Object ... objects) {
        for (Object object : objects) {
            Assert.notNull((Object)object);
        }
    }

    @Deprecated
    public static void notBlank(String ... strings) {
        Assert.noBlanksWithMsg(NO_BLANKS, strings);
    }

    @Deprecated
    public static void noNulls(String msg, Object ... objects) {
        for (Object object : objects) {
            Assert.notNull((Object)object, (String)msg);
        }
    }
}

