/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.kuali.common.util.Assert;

public class CheckSumUtils {
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";
    private static final String UTF8 = "UTF-8";

    public static String getSHA1Checksum(String message) {
        return CheckSumUtils.getChecksum(message, SHA1);
    }

    public static String getMD5Checksum(String message) {
        return CheckSumUtils.getChecksum(message, MD5);
    }

    public static String getMD5Checksum(InputStream in) throws IOException {
        return CheckSumUtils.getChecksum(in, MD5);
    }

    public static String getSHA1Checksum(InputStream in) throws IOException {
        return CheckSumUtils.getChecksum(in, SHA1);
    }

    public static String getChecksum(String message, String algorithm) {
        try {
            return CheckSumUtils.getChecksum(CheckSumUtils.getInputStream(message), algorithm);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
    }

    public static String getChecksum(InputStream in, String algorithm) throws IOException {
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance(algorithm);
            do {
                if ((numRead = in.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] bytes = complete.digest();
            return CheckSumUtils.toHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unexpected message digest error", e);
        }
        catch (IOException e) {
            throw e;
        }
    }

    protected static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    protected static InputStream getInputStream(String message) {
        try {
            return CheckSumUtils.getInputStream(message, UTF8);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static InputStream getInputStream(String message, String encoding) throws UnsupportedEncodingException {
        Assert.noBlanks(message);
        byte[] bytes = message.getBytes(encoding);
        return new ByteArrayInputStream(bytes);
    }
}

