/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.kuali.common.util.base.Exceptions;
import org.kuali.common.util.base.Precondition;

public final class Encodings {
    public static final String UTF8 = "UTF-8";
    public static final String ASCII = "US-ASCII";

    private Encodings() {
    }

    public static final String encodeUTF8(String text) {
        try {
            return URLEncoder.encode(Precondition.checkNotNull(text, "text"), UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.illegalState(e);
        }
    }

    public static final String decodeUTF8(String text) {
        try {
            return URLDecoder.decode(Precondition.checkNotNull(text, "text"), UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.illegalState(e);
        }
    }
}

